/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * PutIdentityPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutIdentityPolicyRequestMarshaller implements
        Marshaller<Request<PutIdentityPolicyRequest>, PutIdentityPolicyRequest> {

    public Request<PutIdentityPolicyRequest> marshall(PutIdentityPolicyRequest putIdentityPolicyRequest) {

        if (putIdentityPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutIdentityPolicyRequest> request = new DefaultRequest<PutIdentityPolicyRequest>(putIdentityPolicyRequest,
                "SESClient");
        request.addParameter("Action", "PutIdentityPolicy");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putIdentityPolicyRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString(putIdentityPolicyRequest.identity()));
        }

        if (putIdentityPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(putIdentityPolicyRequest.policyName()));
        }

        if (putIdentityPolicyRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString(putIdentityPolicyRequest.policy()));
        }

        return request;
    }

}
