/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * RecipientDsnFields StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RecipientDsnFieldsUnmarshaller implements Unmarshaller<RecipientDsnFields, StaxUnmarshallerContext> {

    public RecipientDsnFields unmarshall(StaxUnmarshallerContext context) throws Exception {
        RecipientDsnFields.Builder recipientDsnFields = RecipientDsnFields.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ExtensionField> extensionFields = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                recipientDsnFields.extensionFields(extensionFields);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("FinalRecipient", targetDepth)) {
                    recipientDsnFields.finalRecipient(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Action", targetDepth)) {
                    recipientDsnFields.action(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RemoteMta", targetDepth)) {
                    recipientDsnFields.remoteMta(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    recipientDsnFields.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DiagnosticCode", targetDepth)) {
                    recipientDsnFields.diagnosticCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LastAttemptDate", targetDepth)) {
                    recipientDsnFields.lastAttemptDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ExtensionFields", targetDepth)) {
                    extensionFields = new ArrayList<ExtensionField>();
                    continue;
                }

                if (context.testExpression("ExtensionFields/member", targetDepth)) {
                    extensionFields.add(ExtensionFieldUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    recipientDsnFields.extensionFields(extensionFields);
                    break;
                }
            }
        }
        return recipientDsnFields.build();
    }

    private static final RecipientDsnFieldsUnmarshaller INSTANCE = new RecipientDsnFieldsUnmarshaller();

    public static RecipientDsnFieldsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
