/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * SendTemplatedEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendTemplatedEmailRequestMarshaller implements
        Marshaller<Request<SendTemplatedEmailRequest>, SendTemplatedEmailRequest> {

    public Request<SendTemplatedEmailRequest> marshall(SendTemplatedEmailRequest sendTemplatedEmailRequest) {

        if (sendTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SendTemplatedEmailRequest> request = new DefaultRequest<SendTemplatedEmailRequest>(sendTemplatedEmailRequest,
                "SESClient");
        request.addParameter("Action", "SendTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString(sendTemplatedEmailRequest.source()));
        }

        Destination destination = sendTemplatedEmailRequest.destination();
        if (destination != null) {

            java.util.List<String> toAddressesList = destination.toAddresses();

            if (toAddressesList != null) {
                if (!toAddressesList.isEmpty()) {
                    int toAddressesListIndex = 1;

                    for (String toAddressesListValue : toAddressesList) {
                        if (toAddressesListValue != null) {
                            request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex,
                                    StringUtils.fromString(toAddressesListValue));
                        }
                        toAddressesListIndex++;
                    }
                } else {
                    request.addParameter("Destination.ToAddresses", "");
                }
            }

            java.util.List<String> ccAddressesList = destination.ccAddresses();

            if (ccAddressesList != null) {
                if (!ccAddressesList.isEmpty()) {
                    int ccAddressesListIndex = 1;

                    for (String ccAddressesListValue : ccAddressesList) {
                        if (ccAddressesListValue != null) {
                            request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex,
                                    StringUtils.fromString(ccAddressesListValue));
                        }
                        ccAddressesListIndex++;
                    }
                } else {
                    request.addParameter("Destination.CcAddresses", "");
                }
            }

            java.util.List<String> bccAddressesList = destination.bccAddresses();

            if (bccAddressesList != null) {
                if (!bccAddressesList.isEmpty()) {
                    int bccAddressesListIndex = 1;

                    for (String bccAddressesListValue : bccAddressesList) {
                        if (bccAddressesListValue != null) {
                            request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex,
                                    StringUtils.fromString(bccAddressesListValue));
                        }
                        bccAddressesListIndex++;
                    }
                } else {
                    request.addParameter("Destination.BccAddresses", "");
                }
            }
        }

        java.util.List<String> replyToAddressesList = sendTemplatedEmailRequest.replyToAddresses();

        if (replyToAddressesList != null) {
            if (!replyToAddressesList.isEmpty()) {
                int replyToAddressesListIndex = 1;

                for (String replyToAddressesListValue : replyToAddressesList) {
                    if (replyToAddressesListValue != null) {
                        request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex,
                                StringUtils.fromString(replyToAddressesListValue));
                    }
                    replyToAddressesListIndex++;
                }
            } else {
                request.addParameter("ReplyToAddresses", "");
            }
        }

        if (sendTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendTemplatedEmailRequest.returnPath()));
        }

        if (sendTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendTemplatedEmailRequest.sourceArn()));
        }

        if (sendTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendTemplatedEmailRequest.returnPathArn()));
        }

        java.util.List<MessageTag> tagsList = sendTemplatedEmailRequest.tags();

        if (tagsList != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;

                for (MessageTag tagsListValue : tagsList) {

                    if (tagsListValue.name() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Name",
                                StringUtils.fromString(tagsListValue.name()));
                    }

                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value",
                                StringUtils.fromString(tagsListValue.value()));
                    }
                    tagsListIndex++;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }

        if (sendTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendTemplatedEmailRequest.configurationSetName()));
        }

        if (sendTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringUtils.fromString(sendTemplatedEmailRequest.template()));
        }

        if (sendTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString(sendTemplatedEmailRequest.templateArn()));
        }

        if (sendTemplatedEmailRequest.templateData() != null) {
            request.addParameter("TemplateData", StringUtils.fromString(sendTemplatedEmailRequest.templateData()));
        }

        return request;
    }

}
