/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.IdentityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityVerificationAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetIdentityVerificationAttributesRequest> {
    private final List<String> identities;

    private GetIdentityVerificationAttributesRequest(BuilderImpl builder) {
        this.identities = builder.identities;
    }

    public List<String> identities() {
        return this.identities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesRequest)) {
            return false;
        }
        GetIdentityVerificationAttributesRequest other = (GetIdentityVerificationAttributesRequest)((Object)obj);
        return Objects.equals(this.identities(), other.identities());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identities() != null) {
            sb.append("Identities: ").append(this.identities()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identities": {
                return Optional.of(clazz.cast(this.identities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> identities;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesRequest model) {
            this.identities(model.identities);
        }

        public final Collection<String> getIdentities() {
            return this.identities;
        }

        @Override
        public final Builder identities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(String ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        public final void setIdentities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
        }

        public GetIdentityVerificationAttributesRequest build() {
            return new GetIdentityVerificationAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityVerificationAttributesRequest> {
        public Builder identities(Collection<String> var1);

        public Builder identities(String ... var1);
    }
}

