/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest;

public class SetIdentityDkimEnabledRequestMarshaller
implements Marshaller<Request<SetIdentityDkimEnabledRequest>, SetIdentityDkimEnabledRequest> {
    public Request<SetIdentityDkimEnabledRequest> marshall(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) {
        if (setIdentityDkimEnabledRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setIdentityDkimEnabledRequest, "SESClient");
        request.addParameter("Action", "SetIdentityDkimEnabled");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityDkimEnabledRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)setIdentityDkimEnabledRequest.identity()));
        }
        if (setIdentityDkimEnabledRequest.dkimEnabled() != null) {
            request.addParameter("DkimEnabled", StringUtils.fromBoolean((Boolean)setIdentityDkimEnabledRequest.dkimEnabled()));
        }
        return request;
    }
}

