/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest;

public class TestRenderTemplateRequestMarshaller
implements Marshaller<Request<TestRenderTemplateRequest>, TestRenderTemplateRequest> {
    public Request<TestRenderTemplateRequest> marshall(TestRenderTemplateRequest testRenderTemplateRequest) {
        if (testRenderTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testRenderTemplateRequest, "SESClient");
        request.addParameter("Action", "TestRenderTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (testRenderTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)testRenderTemplateRequest.templateName()));
        }
        if (testRenderTemplateRequest.templateData() != null) {
            request.addParameter("TemplateData", StringUtils.fromString((String)testRenderTemplateRequest.templateData()));
        }
        return request;
    }
}

