/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that email sending is disabled for the configuration set.
 * </p>
 * <p>
 * You can enable or disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationSetSendingPausedException extends SESException implements
        ToCopyableBuilder<ConfigurationSetSendingPausedException.Builder, ConfigurationSetSendingPausedException> {
    private final String configurationSetName;

    private ConfigurationSetSendingPausedException(BuilderImpl builder) {
        super(builder.message);
        this.configurationSetName = builder.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The name of the configuration set for which email sending is disabled.
     * </p>
     * 
     * @return The name of the configuration set for which email sending is disabled.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigurationSetSendingPausedException> {
        /**
         * <p>
         * The name of the configuration set for which email sending is disabled.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set for which email sending is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationSetSendingPausedException model) {
            configurationSetName(model.configurationSetName);
            this.message = model.getMessage();
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ConfigurationSetSendingPausedException build() {
            return new ConfigurationSetSendingPausedException(this);
        }
    }
}
