/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityMailFromDomainAttributesResponse extends SESResponse implements
        ToCopyableBuilder<GetIdentityMailFromDomainAttributesResponse.Builder, GetIdentityMailFromDomainAttributesResponse> {
    private final Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

    private GetIdentityMailFromDomainAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.mailFromDomainAttributes = builder.mailFromDomainAttributes;
    }

    /**
     * <p>
     * A map of identities to custom MAIL FROM attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of identities to custom MAIL FROM attributes.
     */
    public Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes() {
        return mailFromDomainAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomainAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityMailFromDomainAttributesResponse)) {
            return false;
        }
        GetIdentityMailFromDomainAttributesResponse other = (GetIdentityMailFromDomainAttributesResponse) obj;
        return Objects.equals(mailFromDomainAttributes(), other.mailFromDomainAttributes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mailFromDomainAttributes() != null) {
            sb.append("MailFromDomainAttributes: ").append(mailFromDomainAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailFromDomainAttributes":
            return Optional.of(clazz.cast(mailFromDomainAttributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, GetIdentityMailFromDomainAttributesResponse> {
        /**
         * <p>
         * A map of identities to custom MAIL FROM attributes.
         * </p>
         * 
         * @param mailFromDomainAttributes
         *        A map of identities to custom MAIL FROM attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityMailFromDomainAttributesResponse model) {
            mailFromDomainAttributes(model.mailFromDomainAttributes);
        }

        public final Map<String, IdentityMailFromDomainAttributes.Builder> getMailFromDomainAttributes() {
            return mailFromDomainAttributes != null ? CollectionUtils.mapValues(mailFromDomainAttributes,
                    IdentityMailFromDomainAttributes::toBuilder) : null;
        }

        @Override
        public final Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copy(mailFromDomainAttributes);
            return this;
        }

        public final void setMailFromDomainAttributes(
                Map<String, IdentityMailFromDomainAttributes.BuilderImpl> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copyFromBuilder(mailFromDomainAttributes);
        }

        @Override
        public GetIdentityMailFromDomainAttributesResponse build() {
            return new GetIdentityMailFromDomainAttributesResponse(this);
        }
    }
}
