/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTemplateRequest extends SESRequest implements ToCopyableBuilder<GetTemplateRequest.Builder, GetTemplateRequest> {
    private final String templateName;

    private GetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The name of the template you want to retrieve.
     * </p>
     * 
     * @return The name of the template you want to retrieve.
     */
    public String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateRequest)) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (templateName() != null) {
            sb.append("TemplateName: ").append(templateName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.of(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, GetTemplateRequest> {
        /**
         * <p>
         * The name of the template you want to retrieve.
         * </p>
         * 
         * @param templateName
         *        The name of the template you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateRequest model) {
            templateName(model.templateName);
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }
    }
}
