/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTemplateResponse extends SESResponse implements
        ToCopyableBuilder<GetTemplateResponse.Builder, GetTemplateResponse> {
    private final Template template;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
    }

    /**
     * Returns the value of the Template property for this object.
     * 
     * @return The value of the Template property for this object.
     */
    public Template template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse) obj;
        return Objects.equals(template(), other.template());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (template() != null) {
            sb.append("Template: ").append(template()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Template":
            return Optional.of(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, GetTemplateResponse> {
        /**
         * Sets the value of the Template property for this object.
         *
         * @param template
         *        The new value for the Template property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Template template);

        /**
         * Sets the value of the Template property for this object.
         *
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #template(Template)}.
         * 
         * @param template
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #template(Template)
         */
        default Builder template(Consumer<Template.Builder> template) {
            return template(Template.builder().apply(template).build());
        }
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private Template template;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            template(model.template);
        }

        public final Template.Builder getTemplate() {
            return template != null ? template.toBuilder() : null;
        }

        @Override
        public final Builder template(Template template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(Template.BuilderImpl template) {
            this.template = template != null ? template.build() : null;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }
    }
}
