/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the notification attributes of an identity, including whether an identity has Amazon Simple Notification
 * Service (Amazon SNS) topics set for bounce, complaint, and/or delivery notifications, and whether feedback forwarding
 * is enabled for bounce and complaint notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityNotificationAttributes implements
        ToCopyableBuilder<IdentityNotificationAttributes.Builder, IdentityNotificationAttributes> {
    private final String bounceTopic;

    private final String complaintTopic;

    private final String deliveryTopic;

    private final Boolean forwardingEnabled;

    private final Boolean headersInBounceNotificationsEnabled;

    private final Boolean headersInComplaintNotificationsEnabled;

    private final Boolean headersInDeliveryNotificationsEnabled;

    private IdentityNotificationAttributes(BuilderImpl builder) {
        this.bounceTopic = builder.bounceTopic;
        this.complaintTopic = builder.complaintTopic;
        this.deliveryTopic = builder.deliveryTopic;
        this.forwardingEnabled = builder.forwardingEnabled;
        this.headersInBounceNotificationsEnabled = builder.headersInBounceNotificationsEnabled;
        this.headersInComplaintNotificationsEnabled = builder.headersInComplaintNotificationsEnabled;
        this.headersInDeliveryNotificationsEnabled = builder.headersInDeliveryNotificationsEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce notifications.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce
     *         notifications.
     */
    public String bounceTopic() {
        return bounceTopic;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint notifications.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint
     *         notifications.
     */
    public String complaintTopic() {
        return complaintTopic;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery notifications.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery
     *         notifications.
     */
    public String deliveryTopic() {
        return deliveryTopic;
    }

    /**
     * <p>
     * Describes whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code>
     * indicates that Amazon SES will forward bounce and complaint notifications as email, while <code>false</code>
     * indicates that bounce and complaint notifications will be published only to the specified bounce and complaint
     * Amazon SNS topics.
     * </p>
     * 
     * @return Describes whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code>
     *         indicates that Amazon SES will forward bounce and complaint notifications as email, while
     *         <code>false</code> indicates that bounce and complaint notifications will be published only to the
     *         specified bounce and complaint Amazon SNS topics.
     */
    public Boolean forwardingEnabled() {
        return forwardingEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     * <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include headers in bounce
     * notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in bounce
     * notifications.
     * </p>
     * 
     * @return Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     *         <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
     *         bounce notifications, and a value of <code>false</code> specifies that Amazon SES will not include
     *         headers in bounce notifications.
     */
    public Boolean headersInBounceNotificationsEnabled() {
        return headersInBounceNotificationsEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     * <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will include headers in complaint
     * notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in complaint
     * notifications.
     * </p>
     * 
     * @return Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     *         <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
     *         complaint notifications, and a value of <code>false</code> specifies that Amazon SES will not include
     *         headers in complaint notifications.
     */
    public Boolean headersInComplaintNotificationsEnabled() {
        return headersInComplaintNotificationsEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     * <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will include headers in delivery
     * notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in delivery
     * notifications.
     * </p>
     * 
     * @return Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     *         <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
     *         delivery notifications, and a value of <code>false</code> specifies that Amazon SES will not include
     *         headers in delivery notifications.
     */
    public Boolean headersInDeliveryNotificationsEnabled() {
        return headersInDeliveryNotificationsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bounceTopic());
        hashCode = 31 * hashCode + Objects.hashCode(complaintTopic());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryTopic());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(headersInBounceNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(headersInComplaintNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(headersInDeliveryNotificationsEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityNotificationAttributes)) {
            return false;
        }
        IdentityNotificationAttributes other = (IdentityNotificationAttributes) obj;
        return Objects.equals(bounceTopic(), other.bounceTopic()) && Objects.equals(complaintTopic(), other.complaintTopic())
                && Objects.equals(deliveryTopic(), other.deliveryTopic())
                && Objects.equals(forwardingEnabled(), other.forwardingEnabled())
                && Objects.equals(headersInBounceNotificationsEnabled(), other.headersInBounceNotificationsEnabled())
                && Objects.equals(headersInComplaintNotificationsEnabled(), other.headersInComplaintNotificationsEnabled())
                && Objects.equals(headersInDeliveryNotificationsEnabled(), other.headersInDeliveryNotificationsEnabled());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bounceTopic() != null) {
            sb.append("BounceTopic: ").append(bounceTopic()).append(",");
        }
        if (complaintTopic() != null) {
            sb.append("ComplaintTopic: ").append(complaintTopic()).append(",");
        }
        if (deliveryTopic() != null) {
            sb.append("DeliveryTopic: ").append(deliveryTopic()).append(",");
        }
        if (forwardingEnabled() != null) {
            sb.append("ForwardingEnabled: ").append(forwardingEnabled()).append(",");
        }
        if (headersInBounceNotificationsEnabled() != null) {
            sb.append("HeadersInBounceNotificationsEnabled: ").append(headersInBounceNotificationsEnabled()).append(",");
        }
        if (headersInComplaintNotificationsEnabled() != null) {
            sb.append("HeadersInComplaintNotificationsEnabled: ").append(headersInComplaintNotificationsEnabled()).append(",");
        }
        if (headersInDeliveryNotificationsEnabled() != null) {
            sb.append("HeadersInDeliveryNotificationsEnabled: ").append(headersInDeliveryNotificationsEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BounceTopic":
            return Optional.of(clazz.cast(bounceTopic()));
        case "ComplaintTopic":
            return Optional.of(clazz.cast(complaintTopic()));
        case "DeliveryTopic":
            return Optional.of(clazz.cast(deliveryTopic()));
        case "ForwardingEnabled":
            return Optional.of(clazz.cast(forwardingEnabled()));
        case "HeadersInBounceNotificationsEnabled":
            return Optional.of(clazz.cast(headersInBounceNotificationsEnabled()));
        case "HeadersInComplaintNotificationsEnabled":
            return Optional.of(clazz.cast(headersInComplaintNotificationsEnabled()));
        case "HeadersInDeliveryNotificationsEnabled":
            return Optional.of(clazz.cast(headersInDeliveryNotificationsEnabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityNotificationAttributes> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce notifications.
         * </p>
         * 
         * @param bounceTopic
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounceTopic(String bounceTopic);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint notifications.
         * </p>
         * 
         * @param complaintTopic
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaintTopic(String complaintTopic);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery notifications.
         * </p>
         * 
         * @param deliveryTopic
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryTopic(String deliveryTopic);

        /**
         * <p>
         * Describes whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code>
         * indicates that Amazon SES will forward bounce and complaint notifications as email, while <code>false</code>
         * indicates that bounce and complaint notifications will be published only to the specified bounce and
         * complaint Amazon SNS topics.
         * </p>
         * 
         * @param forwardingEnabled
         *        Describes whether Amazon SES will forward bounce and complaint notifications as email.
         *        <code>true</code> indicates that Amazon SES will forward bounce and complaint notifications as email,
         *        while <code>false</code> indicates that bounce and complaint notifications will be published only to
         *        the specified bounce and complaint Amazon SNS topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingEnabled(Boolean forwardingEnabled);

        /**
         * <p>
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         * <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include headers in bounce
         * notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in bounce
         * notifications.
         * </p>
         * 
         * @param headersInBounceNotificationsEnabled
         *        Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         *        <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
         *        bounce notifications, and a value of <code>false</code> specifies that Amazon SES will not include
         *        headers in bounce notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled);

        /**
         * <p>
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         * <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
         * complaint notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers
         * in complaint notifications.
         * </p>
         * 
         * @param headersInComplaintNotificationsEnabled
         *        Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         *        <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
         *        complaint notifications, and a value of <code>false</code> specifies that Amazon SES will not include
         *        headers in complaint notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled);

        /**
         * <p>
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         * <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
         * delivery notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers
         * in delivery notifications.
         * </p>
         * 
         * @param headersInDeliveryNotificationsEnabled
         *        Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         *        <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will include headers in
         *        delivery notifications, and a value of <code>false</code> specifies that Amazon SES will not include
         *        headers in delivery notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String bounceTopic;

        private String complaintTopic;

        private String deliveryTopic;

        private Boolean forwardingEnabled;

        private Boolean headersInBounceNotificationsEnabled;

        private Boolean headersInComplaintNotificationsEnabled;

        private Boolean headersInDeliveryNotificationsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityNotificationAttributes model) {
            bounceTopic(model.bounceTopic);
            complaintTopic(model.complaintTopic);
            deliveryTopic(model.deliveryTopic);
            forwardingEnabled(model.forwardingEnabled);
            headersInBounceNotificationsEnabled(model.headersInBounceNotificationsEnabled);
            headersInComplaintNotificationsEnabled(model.headersInComplaintNotificationsEnabled);
            headersInDeliveryNotificationsEnabled(model.headersInDeliveryNotificationsEnabled);
        }

        public final String getBounceTopic() {
            return bounceTopic;
        }

        @Override
        public final Builder bounceTopic(String bounceTopic) {
            this.bounceTopic = bounceTopic;
            return this;
        }

        public final void setBounceTopic(String bounceTopic) {
            this.bounceTopic = bounceTopic;
        }

        public final String getComplaintTopic() {
            return complaintTopic;
        }

        @Override
        public final Builder complaintTopic(String complaintTopic) {
            this.complaintTopic = complaintTopic;
            return this;
        }

        public final void setComplaintTopic(String complaintTopic) {
            this.complaintTopic = complaintTopic;
        }

        public final String getDeliveryTopic() {
            return deliveryTopic;
        }

        @Override
        public final Builder deliveryTopic(String deliveryTopic) {
            this.deliveryTopic = deliveryTopic;
            return this;
        }

        public final void setDeliveryTopic(String deliveryTopic) {
            this.deliveryTopic = deliveryTopic;
        }

        public final Boolean getForwardingEnabled() {
            return forwardingEnabled;
        }

        @Override
        public final Builder forwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
            return this;
        }

        public final void setForwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
        }

        public final Boolean getHeadersInBounceNotificationsEnabled() {
            return headersInBounceNotificationsEnabled;
        }

        @Override
        public final Builder headersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled) {
            this.headersInBounceNotificationsEnabled = headersInBounceNotificationsEnabled;
            return this;
        }

        public final void setHeadersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled) {
            this.headersInBounceNotificationsEnabled = headersInBounceNotificationsEnabled;
        }

        public final Boolean getHeadersInComplaintNotificationsEnabled() {
            return headersInComplaintNotificationsEnabled;
        }

        @Override
        public final Builder headersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled) {
            this.headersInComplaintNotificationsEnabled = headersInComplaintNotificationsEnabled;
            return this;
        }

        public final void setHeadersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled) {
            this.headersInComplaintNotificationsEnabled = headersInComplaintNotificationsEnabled;
        }

        public final Boolean getHeadersInDeliveryNotificationsEnabled() {
            return headersInDeliveryNotificationsEnabled;
        }

        @Override
        public final Builder headersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled) {
            this.headersInDeliveryNotificationsEnabled = headersInDeliveryNotificationsEnabled;
            return this;
        }

        public final void setHeadersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled) {
            this.headersInDeliveryNotificationsEnabled = headersInDeliveryNotificationsEnabled;
        }

        @Override
        public IdentityNotificationAttributes build() {
            return new IdentityNotificationAttributes(this);
        }
    }
}
