/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error message for
 * details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidSNSDestinationException extends SESException implements
        ToCopyableBuilder<InvalidSNSDestinationException.Builder, InvalidSNSDestinationException> {
    private final String configurationSetName;

    private final String eventDestinationName;

    private InvalidSNSDestinationException(BuilderImpl builder) {
        super(builder.message);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Indicates that the configuration set does not exist.
     * </p>
     * 
     * @return Indicates that the configuration set does not exist.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * Indicates that the event destination does not exist.
     * </p>
     * 
     * @return Indicates that the event destination does not exist.
     */
    public String eventDestinationName() {
        return eventDestinationName;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidSNSDestinationException> {
        /**
         * <p>
         * Indicates that the configuration set does not exist.
         * </p>
         * 
         * @param configurationSetName
         *        Indicates that the configuration set does not exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * Indicates that the event destination does not exist.
         * </p>
         * 
         * @param eventDestinationName
         *        Indicates that the event destination does not exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinationName(String eventDestinationName);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private String eventDestinationName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSNSDestinationException model) {
            configurationSetName(model.configurationSetName);
            eventDestinationName(model.eventDestinationName);
            this.message = model.getMessage();
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getEventDestinationName() {
            return eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidSNSDestinationException build() {
            return new InvalidSNSDestinationException(this);
        }
    }
}
