/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of configuration sets associated with your AWS account. Configuration sets enable you to publish email sending
 * events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListConfigurationSetsResponse extends SESResponse implements
        ToCopyableBuilder<ListConfigurationSetsResponse.Builder, ListConfigurationSetsResponse> {
    private final List<ConfigurationSet> configurationSets;

    private final String nextToken;

    private ListConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of configuration sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of configuration sets.
     */
    public List<ConfigurationSet> configurationSets() {
        return configurationSets;
    }

    /**
     * <p>
     * A token indicating that there are additional configuration sets available to be listed. Pass this token to
     * successive calls of <code>ListConfigurationSets</code>.
     * </p>
     * 
     * @return A token indicating that there are additional configuration sets available to be listed. Pass this token
     *         to successive calls of <code>ListConfigurationSets</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsResponse)) {
            return false;
        }
        ListConfigurationSetsResponse other = (ListConfigurationSetsResponse) obj;
        return Objects.equals(configurationSets(), other.configurationSets()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationSets() != null) {
            sb.append("ConfigurationSets: ").append(configurationSets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSets":
            return Optional.of(clazz.cast(configurationSets()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, ListConfigurationSetsResponse> {
        /**
         * <p>
         * A list of configuration sets.
         * </p>
         * 
         * @param configurationSets
         *        A list of configuration sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(Collection<ConfigurationSet> configurationSets);

        /**
         * <p>
         * A list of configuration sets.
         * </p>
         * 
         * @param configurationSets
         *        A list of configuration sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(ConfigurationSet... configurationSets);

        /**
         * <p>
         * A token indicating that there are additional configuration sets available to be listed. Pass this token to
         * successive calls of <code>ListConfigurationSets</code>.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional configuration sets available to be listed. Pass this
         *        token to successive calls of <code>ListConfigurationSets</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private List<ConfigurationSet> configurationSets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsResponse model) {
            configurationSets(model.configurationSets);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigurationSet.Builder> getConfigurationSets() {
            return configurationSets != null ? configurationSets.stream().map(ConfigurationSet::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationSets(Collection<ConfigurationSet> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(ConfigurationSet... configurationSets) {
            configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        public final void setConfigurationSets(Collection<ConfigurationSet.BuilderImpl> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copyFromBuilder(configurationSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationSetsResponse build() {
            return new ListConfigurationSetsResponse(this);
        }
    }
}
