/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of names of sending authorization policies that apply to an identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentityPoliciesResponse extends SESResponse implements
        ToCopyableBuilder<ListIdentityPoliciesResponse.Builder, ListIdentityPoliciesResponse> {
    private final List<String> policyNames;

    private ListIdentityPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policyNames = builder.policyNames;
    }

    /**
     * <p>
     * A list of names of policies that apply to the specified identity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of names of policies that apply to the specified identity.
     */
    public List<String> policyNames() {
        return policyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoliciesResponse)) {
            return false;
        }
        ListIdentityPoliciesResponse other = (ListIdentityPoliciesResponse) obj;
        return Objects.equals(policyNames(), other.policyNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyNames() != null) {
            sb.append("PolicyNames: ").append(policyNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyNames":
            return Optional.of(clazz.cast(policyNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, ListIdentityPoliciesResponse> {
        /**
         * <p>
         * A list of names of policies that apply to the specified identity.
         * </p>
         * 
         * @param policyNames
         *        A list of names of policies that apply to the specified identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(Collection<String> policyNames);

        /**
         * <p>
         * A list of names of policies that apply to the specified identity.
         * </p>
         * 
         * @param policyNames
         *        A list of names of policies that apply to the specified identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(String... policyNames);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoliciesResponse model) {
            policyNames(model.policyNames);
        }

        public final Collection<String> getPolicyNames() {
            return policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
        }

        @Override
        public ListIdentityPoliciesResponse build() {
            return new ListIdentityPoliciesResponse(this);
        }
    }
}
