/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the raw data of the message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RawMessage implements ToCopyableBuilder<RawMessage.Builder, RawMessage> {
    private final ByteBuffer data;

    private RawMessage(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * <p>
     * The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES directly through
     * the HTTPS interface. If you are accessing Amazon SES using an AWS SDK, the SDK takes care of the base 64-encoding
     * for you. In all cases, the client must ensure that the message format complies with Internet email standards
     * regarding email header fields, MIME types, and MIME encoding.
     * </p>
     * <p>
     * The To:, CC:, and BCC: headers in the raw message can contain a group list.
     * </p>
     * <p>
     * If you are using <code>SendRawEmail</code> with sending authorization, you can include X-headers in the raw
     * message to specify the "Source," "From," and "Return-Path" addresses. For more information, see the documentation
     * for <code>SendRawEmail</code>.
     * </p>
     * <important>
     * <p>
     * Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before sending the
     * email.
     * </p>
     * </important>
     * <p>
     * For more information, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES directly
     *         through the HTTPS interface. If you are accessing Amazon SES using an AWS SDK, the SDK takes care of the
     *         base 64-encoding for you. In all cases, the client must ensure that the message format complies with
     *         Internet email standards regarding email header fields, MIME types, and MIME encoding.</p>
     *         <p>
     *         The To:, CC:, and BCC: headers in the raw message can contain a group list.
     *         </p>
     *         <p>
     *         If you are using <code>SendRawEmail</code> with sending authorization, you can include X-headers in the
     *         raw message to specify the "Source," "From," and "Return-Path" addresses. For more information, see the
     *         documentation for <code>SendRawEmail</code>.
     *         </p>
     *         <important>
     *         <p>
     *         Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before
     *         sending the email.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, go to the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
     *         Guide</a>.
     */
    public ByteBuffer data() {
        return data == null ? null : data.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawMessage)) {
            return false;
        }
        RawMessage other = (RawMessage) obj;
        return Objects.equals(data(), other.data());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (data() != null) {
            sb.append("Data: ").append(data()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.of(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RawMessage> {
        /**
         * <p>
         * The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES directly
         * through the HTTPS interface. If you are accessing Amazon SES using an AWS SDK, the SDK takes care of the base
         * 64-encoding for you. In all cases, the client must ensure that the message format complies with Internet
         * email standards regarding email header fields, MIME types, and MIME encoding.
         * </p>
         * <p>
         * The To:, CC:, and BCC: headers in the raw message can contain a group list.
         * </p>
         * <p>
         * If you are using <code>SendRawEmail</code> with sending authorization, you can include X-headers in the raw
         * message to specify the "Source," "From," and "Return-Path" addresses. For more information, see the
         * documentation for <code>SendRawEmail</code>.
         * </p>
         * <important>
         * <p>
         * Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before sending
         * the email.
         * </p>
         * </important>
         * <p>
         * For more information, go to the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
         * Guide</a>.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param data
         *        The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES
         *        directly through the HTTPS interface. If you are accessing Amazon SES using an AWS SDK, the SDK takes
         *        care of the base 64-encoding for you. In all cases, the client must ensure that the message format
         *        complies with Internet email standards regarding email header fields, MIME types, and MIME
         *        encoding.</p>
         *        <p>
         *        The To:, CC:, and BCC: headers in the raw message can contain a group list.
         *        </p>
         *        <p>
         *        If you are using <code>SendRawEmail</code> with sending authorization, you can include X-headers in
         *        the raw message to specify the "Source," "From," and "Return-Path" addresses. For more information,
         *        see the documentation for <code>SendRawEmail</code>.
         *        </p>
         *        <important>
         *        <p>
         *        Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before
         *        sending the email.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, go to the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(ByteBuffer data);
    }

    static final class BuilderImpl implements Builder {
        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(RawMessage model) {
            data(model.data);
        }

        public final ByteBuffer getData() {
            return data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy(data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy(data);
        }

        @Override
        public RawMessage build() {
            return new RawMessage(this);
        }
    }
}
