/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SendBulkTemplatedEmailResponse extends SESResponse implements
        ToCopyableBuilder<SendBulkTemplatedEmailResponse.Builder, SendBulkTemplatedEmailResponse> {
    private final List<BulkEmailDestinationStatus> status;

    private SendBulkTemplatedEmailResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
     */
    public List<BulkEmailDestinationStatus> status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkTemplatedEmailResponse)) {
            return false;
        }
        SendBulkTemplatedEmailResponse other = (SendBulkTemplatedEmailResponse) obj;
        return Objects.equals(status(), other.status());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.of(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, SendBulkTemplatedEmailResponse> {
        /**
         * <p>
         * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * </p>
         * 
         * @param status
         *        The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<BulkEmailDestinationStatus> status);

        /**
         * <p>
         * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * </p>
         * 
         * @param status
         *        The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(BulkEmailDestinationStatus... status);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private List<BulkEmailDestinationStatus> status;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkTemplatedEmailResponse model) {
            status(model.status);
        }

        public final Collection<BulkEmailDestinationStatus.Builder> getStatus() {
            return status != null ? status.stream().map(BulkEmailDestinationStatus::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder status(Collection<BulkEmailDestinationStatus> status) {
            this.status = BulkEmailDestinationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(BulkEmailDestinationStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final void setStatus(Collection<BulkEmailDestinationStatus.BuilderImpl> status) {
            this.status = BulkEmailDestinationStatusListCopier.copyFromBuilder(status);
        }

        @Override
        public SendBulkTemplatedEmailResponse build() {
            return new SendBulkTemplatedEmailResponse(this);
        }
    }
}
