/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more information about
 * setting up Easy DKIM, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon
 * SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetIdentityDkimEnabledRequest extends SESRequest implements
        ToCopyableBuilder<SetIdentityDkimEnabledRequest.Builder, SetIdentityDkimEnabledRequest> {
    private final String identity;

    private final Boolean dkimEnabled;

    private SetIdentityDkimEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.dkimEnabled = builder.dkimEnabled;
    }

    /**
     * <p>
     * The identity for which DKIM signing should be enabled or disabled.
     * </p>
     * 
     * @return The identity for which DKIM signing should be enabled or disabled.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for this
     * identity; <code>false</code> to disable it.
     * </p>
     * 
     * @return Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for
     *         this identity; <code>false</code> to disable it.
     */
    public Boolean dkimEnabled() {
        return dkimEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(dkimEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityDkimEnabledRequest)) {
            return false;
        }
        SetIdentityDkimEnabledRequest other = (SetIdentityDkimEnabledRequest) obj;
        return Objects.equals(identity(), other.identity()) && Objects.equals(dkimEnabled(), other.dkimEnabled());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (dkimEnabled() != null) {
            sb.append("DkimEnabled: ").append(dkimEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.of(clazz.cast(identity()));
        case "DkimEnabled":
            return Optional.of(clazz.cast(dkimEnabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, SetIdentityDkimEnabledRequest> {
        /**
         * <p>
         * The identity for which DKIM signing should be enabled or disabled.
         * </p>
         * 
         * @param identity
         *        The identity for which DKIM signing should be enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for
         * this identity; <code>false</code> to disable it.
         * </p>
         * 
         * @param dkimEnabled
         *        Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing
         *        for this identity; <code>false</code> to disable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimEnabled(Boolean dkimEnabled);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String identity;

        private Boolean dkimEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityDkimEnabledRequest model) {
            identity(model.identity);
            dkimEnabled(model.dkimEnabled);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Boolean getDkimEnabled() {
            return dkimEnabled;
        }

        @Override
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityDkimEnabledRequest build() {
            return new SetIdentityDkimEnabledRequest(this);
        }
    }
}
