/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetIdentityNotificationAttributesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityNotificationAttributesResponseUnmarshaller implements
        Unmarshaller<GetIdentityNotificationAttributesResponse, StaxUnmarshallerContext> {

    private static class NotificationAttributesMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, IdentityNotificationAttributes>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, IdentityNotificationAttributes> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, IdentityNotificationAttributes> entry = new MapEntry<String, IdentityNotificationAttributes>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(IdentityNotificationAttributesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final NotificationAttributesMapEntryUnmarshaller INSTANCE = new NotificationAttributesMapEntryUnmarshaller();

        public static NotificationAttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public GetIdentityNotificationAttributesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetIdentityNotificationAttributesResponse.Builder getIdentityNotificationAttributesResponse = GetIdentityNotificationAttributesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.Map<String, IdentityNotificationAttributes> notificationAttributes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getIdentityNotificationAttributesResponse.notificationAttributes(notificationAttributes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("NotificationAttributes/entry", targetDepth)) {
                    if (notificationAttributes == null) {
                        notificationAttributes = new java.util.HashMap<>();
                    }
                    Entry<String, IdentityNotificationAttributes> entry = NotificationAttributesMapEntryUnmarshaller
                            .getInstance().unmarshall(context);
                    // getIdentityNotificationAttributesResponse.addNotificationAttributesEntry(entry.getKey(),
                    // entry.getValue());

                    notificationAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getIdentityNotificationAttributesResponse.notificationAttributes(notificationAttributes);
                    break;
                }
            }
        }
        return getIdentityNotificationAttributesResponse.build();
    }

    private static final GetIdentityNotificationAttributesResponseUnmarshaller INSTANCE = new GetIdentityNotificationAttributesResponseUnmarshaller();

    public static GetIdentityNotificationAttributesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
