/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListIdentitiesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListIdentitiesResponseUnmarshaller implements Unmarshaller<ListIdentitiesResponse, StaxUnmarshallerContext> {

    public ListIdentitiesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListIdentitiesResponse.Builder listIdentitiesResponse = ListIdentitiesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<String> identities = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listIdentitiesResponse.identities(identities);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Identities", targetDepth)) {
                    identities = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Identities/member", targetDepth)) {
                    identities.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listIdentitiesResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listIdentitiesResponse.identities(identities);
                    break;
                }
            }
        }
        return listIdentitiesResponse.build();
    }

    private static final ListIdentitiesResponseUnmarshaller INSTANCE = new ListIdentitiesResponseUnmarshaller();

    public static ListIdentitiesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
