/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * SendBulkTemplatedEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendBulkTemplatedEmailRequestMarshaller implements
        Marshaller<Request<SendBulkTemplatedEmailRequest>, SendBulkTemplatedEmailRequest> {

    public Request<SendBulkTemplatedEmailRequest> marshall(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {

        if (sendBulkTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SendBulkTemplatedEmailRequest> request = new DefaultRequest<SendBulkTemplatedEmailRequest>(
                sendBulkTemplatedEmailRequest, "SESClient");
        request.addParameter("Action", "SendBulkTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendBulkTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString(sendBulkTemplatedEmailRequest.source()));
        }

        if (sendBulkTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.sourceArn()));
        }

        java.util.List<String> replyToAddressesList = sendBulkTemplatedEmailRequest.replyToAddresses();

        if (replyToAddressesList != null) {
            if (!replyToAddressesList.isEmpty()) {
                int replyToAddressesListIndex = 1;

                for (String replyToAddressesListValue : replyToAddressesList) {
                    if (replyToAddressesListValue != null) {
                        request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex,
                                StringUtils.fromString(replyToAddressesListValue));
                    }
                    replyToAddressesListIndex++;
                }
            } else {
                request.addParameter("ReplyToAddresses", "");
            }
        }

        if (sendBulkTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendBulkTemplatedEmailRequest.returnPath()));
        }

        if (sendBulkTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.returnPathArn()));
        }

        if (sendBulkTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringUtils.fromString(sendBulkTemplatedEmailRequest.configurationSetName()));
        }

        java.util.List<MessageTag> defaultTagsList = sendBulkTemplatedEmailRequest.defaultTags();

        if (defaultTagsList != null) {
            if (!defaultTagsList.isEmpty()) {
                int defaultTagsListIndex = 1;

                for (MessageTag defaultTagsListValue : defaultTagsList) {

                    if (defaultTagsListValue.name() != null) {
                        request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Name",
                                StringUtils.fromString(defaultTagsListValue.name()));
                    }

                    if (defaultTagsListValue.value() != null) {
                        request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Value",
                                StringUtils.fromString(defaultTagsListValue.value()));
                    }
                    defaultTagsListIndex++;
                }
            } else {
                request.addParameter("DefaultTags", "");
            }
        }

        if (sendBulkTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringUtils.fromString(sendBulkTemplatedEmailRequest.template()));
        }

        if (sendBulkTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.templateArn()));
        }

        if (sendBulkTemplatedEmailRequest.defaultTemplateData() != null) {
            request.addParameter("DefaultTemplateData",
                    StringUtils.fromString(sendBulkTemplatedEmailRequest.defaultTemplateData()));
        }

        java.util.List<BulkEmailDestination> destinationsList = sendBulkTemplatedEmailRequest.destinations();

        if (destinationsList != null) {
            if (!destinationsList.isEmpty()) {
                int destinationsListIndex = 1;

                for (BulkEmailDestination destinationsListValue : destinationsList) {

                    Destination destination = destinationsListValue.destination();
                    if (destination != null) {

                        java.util.List<String> toAddressesList = destination.toAddresses();

                        if (toAddressesList != null) {
                            if (!toAddressesList.isEmpty()) {
                                int toAddressesListIndex = 1;

                                for (String toAddressesListValue : toAddressesList) {
                                    if (toAddressesListValue != null) {
                                        request.addParameter("Destinations.member." + destinationsListIndex
                                                + ".Destination.ToAddresses.member." + toAddressesListIndex,
                                                StringUtils.fromString(toAddressesListValue));
                                    }
                                    toAddressesListIndex++;
                                }
                            } else {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses",
                                        "");
                            }
                        }

                        java.util.List<String> ccAddressesList = destination.ccAddresses();

                        if (ccAddressesList != null) {
                            if (!ccAddressesList.isEmpty()) {
                                int ccAddressesListIndex = 1;

                                for (String ccAddressesListValue : ccAddressesList) {
                                    if (ccAddressesListValue != null) {
                                        request.addParameter("Destinations.member." + destinationsListIndex
                                                + ".Destination.CcAddresses.member." + ccAddressesListIndex,
                                                StringUtils.fromString(ccAddressesListValue));
                                    }
                                    ccAddressesListIndex++;
                                }
                            } else {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses",
                                        "");
                            }
                        }

                        java.util.List<String> bccAddressesList = destination.bccAddresses();

                        if (bccAddressesList != null) {
                            if (!bccAddressesList.isEmpty()) {
                                int bccAddressesListIndex = 1;

                                for (String bccAddressesListValue : bccAddressesList) {
                                    if (bccAddressesListValue != null) {
                                        request.addParameter("Destinations.member." + destinationsListIndex
                                                + ".Destination.BccAddresses.member." + bccAddressesListIndex,
                                                StringUtils.fromString(bccAddressesListValue));
                                    }
                                    bccAddressesListIndex++;
                                }
                            } else {
                                request.addParameter(
                                        "Destinations.member." + destinationsListIndex + ".Destination.BccAddresses", "");
                            }
                        }
                    }

                    java.util.List<MessageTag> replacementTagsList = destinationsListValue.replacementTags();

                    if (replacementTagsList != null) {
                        if (!replacementTagsList.isEmpty()) {
                            int replacementTagsListIndex = 1;

                            for (MessageTag replacementTagsListValue : replacementTagsList) {

                                if (replacementTagsListValue.name() != null) {
                                    request.addParameter("Destinations.member." + destinationsListIndex
                                            + ".ReplacementTags.member." + replacementTagsListIndex + ".Name",
                                            StringUtils.fromString(replacementTagsListValue.name()));
                                }

                                if (replacementTagsListValue.value() != null) {
                                    request.addParameter("Destinations.member." + destinationsListIndex
                                            + ".ReplacementTags.member." + replacementTagsListIndex + ".Value",
                                            StringUtils.fromString(replacementTagsListValue.value()));
                                }
                                replacementTagsListIndex++;
                            }
                        } else {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags", "");
                        }
                    }

                    if (destinationsListValue.replacementTemplateData() != null) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTemplateData",
                                StringUtils.fromString(destinationsListValue.replacementTemplateData()));
                    }
                    destinationsListIndex++;
                }
            } else {
                request.addParameter("Destinations", "");
            }
        }

        return request;
    }

}
