/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * VerifyDomainIdentityRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VerifyDomainIdentityRequestMarshaller implements
        Marshaller<Request<VerifyDomainIdentityRequest>, VerifyDomainIdentityRequest> {

    public Request<VerifyDomainIdentityRequest> marshall(VerifyDomainIdentityRequest verifyDomainIdentityRequest) {

        if (verifyDomainIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<VerifyDomainIdentityRequest> request = new DefaultRequest<VerifyDomainIdentityRequest>(
                verifyDomainIdentityRequest, "SESClient");
        request.addParameter("Action", "VerifyDomainIdentity");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (verifyDomainIdentityRequest.domain() != null) {
            request.addParameter("Domain", StringUtils.fromString(verifyDomainIdentityRequest.domain()));
        }

        return request;
    }

}
