/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ses.model.ReceiptIpFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptFilter
implements ToCopyableBuilder<Builder, ReceiptFilter> {
    private final String name;
    private final ReceiptIpFilter ipFilter;

    private ReceiptFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.ipFilter = builder.ipFilter;
    }

    public String name() {
        return this.name;
    }

    public ReceiptIpFilter ipFilter() {
        return this.ipFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptFilter)) {
            return false;
        }
        ReceiptFilter other = (ReceiptFilter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ipFilter(), other.ipFilter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.ipFilter() != null) {
            sb.append("IpFilter: ").append(this.ipFilter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "IpFilter": {
                return Optional.of(clazz.cast(this.ipFilter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ReceiptIpFilter ipFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptFilter model) {
            this.name(model.name);
            this.ipFilter(model.ipFilter);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ReceiptIpFilter.Builder getIpFilter() {
            return this.ipFilter != null ? this.ipFilter.toBuilder() : null;
        }

        @Override
        public final Builder ipFilter(ReceiptIpFilter ipFilter) {
            this.ipFilter = ipFilter;
            return this;
        }

        public final void setIpFilter(ReceiptIpFilter.BuilderImpl ipFilter) {
            this.ipFilter = ipFilter != null ? ipFilter.build() : null;
        }

        public ReceiptFilter build() {
            return new ReceiptFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptFilter> {
        public Builder name(String var1);

        public Builder ipFilter(ReceiptIpFilter var1);

        default public Builder ipFilter(Consumer<ReceiptIpFilter.Builder> ipFilter) {
            return this.ipFilter((ReceiptIpFilter)((ReceiptIpFilter.Builder)ReceiptIpFilter.builder().apply(ipFilter)).build());
        }
    }
}

