/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.BulkEmailDestination;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest;

public class SendBulkTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendBulkTemplatedEmailRequest>, SendBulkTemplatedEmailRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<SendBulkTemplatedEmailRequest> marshall(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {
        List<BulkEmailDestination> destinationsList;
        List<MessageTag> defaultTagsList;
        List<String> replyToAddressesList;
        if (sendBulkTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)sendBulkTemplatedEmailRequest, "SESClient");
        request.addParameter("Action", "SendBulkTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBulkTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.source()));
        }
        if (sendBulkTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.sourceArn()));
        }
        if ((replyToAddressesList = sendBulkTemplatedEmailRequest.replyToAddresses()) != null) {
            if (!replyToAddressesList.isEmpty()) {
                int replyToAddressesListIndex = 1;
                for (Object replyToAddressesListValue : replyToAddressesList) {
                    if (replyToAddressesListValue != null) {
                        request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)replyToAddressesListValue));
                    }
                    ++replyToAddressesListIndex;
                }
            } else {
                request.addParameter("ReplyToAddresses", "");
            }
        }
        if (sendBulkTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.returnPath()));
        }
        if (sendBulkTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.returnPathArn()));
        }
        if (sendBulkTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.configurationSetName()));
        }
        if ((defaultTagsList = sendBulkTemplatedEmailRequest.defaultTags()) != null) {
            if (!defaultTagsList.isEmpty()) {
                int defaultTagsListIndex = 1;
                for (MessageTag defaultTagsListValue : defaultTagsList) {
                    if (defaultTagsListValue.name() != null) {
                        request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Name", StringUtils.fromString((String)defaultTagsListValue.name()));
                    }
                    if (defaultTagsListValue.value() != null) {
                        request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Value", StringUtils.fromString((String)defaultTagsListValue.value()));
                    }
                    ++defaultTagsListIndex;
                }
            } else {
                request.addParameter("DefaultTags", "");
            }
        }
        if (sendBulkTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.template()));
        }
        if (sendBulkTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.templateArn()));
        }
        if (sendBulkTemplatedEmailRequest.defaultTemplateData() != null) {
            request.addParameter("DefaultTemplateData", StringUtils.fromString((String)sendBulkTemplatedEmailRequest.defaultTemplateData()));
        }
        if ((destinationsList = sendBulkTemplatedEmailRequest.destinations()) != null) {
            if (!destinationsList.isEmpty()) {
                int destinationsListIndex = 1;
                for (BulkEmailDestination destinationsListValue : destinationsList) {
                    List<MessageTag> replacementTagsList;
                    Destination destination = destinationsListValue.destination();
                    if (destination != null) {
                        List<String> bccAddressesList;
                        List<String> ccAddressesList;
                        List<String> toAddressesList = destination.toAddresses();
                        if (toAddressesList != null) {
                            if (!toAddressesList.isEmpty()) {
                                int toAddressesListIndex = 1;
                                for (Object toAddressesListValue : toAddressesList) {
                                    if (toAddressesListValue != null) {
                                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)toAddressesListValue));
                                    }
                                    ++toAddressesListIndex;
                                }
                            } else {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses", "");
                            }
                        }
                        if ((ccAddressesList = destination.ccAddresses()) != null) {
                            if (!ccAddressesList.isEmpty()) {
                                Object toAddressesListValue;
                                int ccAddressesListIndex = 1;
                                toAddressesListValue = ccAddressesList.iterator();
                                while (toAddressesListValue.hasNext()) {
                                    String ccAddressesListValue = (String)toAddressesListValue.next();
                                    if (ccAddressesListValue != null) {
                                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString((String)ccAddressesListValue));
                                    }
                                    ++ccAddressesListIndex;
                                }
                            } else {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses", "");
                            }
                        }
                        if ((bccAddressesList = destination.bccAddresses()) != null) {
                            if (!bccAddressesList.isEmpty()) {
                                int bccAddressesListIndex = 1;
                                for (String bccAddressesListValue : bccAddressesList) {
                                    if (bccAddressesListValue != null) {
                                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString((String)bccAddressesListValue));
                                    }
                                    ++bccAddressesListIndex;
                                }
                            } else {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses", "");
                            }
                        }
                    }
                    if ((replacementTagsList = destinationsListValue.replacementTags()) != null) {
                        if (!replacementTagsList.isEmpty()) {
                            int replacementTagsListIndex = 1;
                            for (MessageTag replacementTagsListValue : replacementTagsList) {
                                if (replacementTagsListValue.name() != null) {
                                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Name", StringUtils.fromString((String)replacementTagsListValue.name()));
                                }
                                if (replacementTagsListValue.value() != null) {
                                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Value", StringUtils.fromString((String)replacementTagsListValue.value()));
                                }
                                ++replacementTagsListIndex;
                            }
                        } else {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags", "");
                        }
                    }
                    if (destinationsListValue.replacementTemplateData() != null) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTemplateData", StringUtils.fromString((String)destinationsListValue.replacementTemplateData()));
                    }
                    ++destinationsListIndex;
                }
            } else {
                request.addParameter("Destinations", "");
            }
        }
        return request;
    }
}

