/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a configuration set event destination. A configuration set event destination, which
 * can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS service in which Amazon SES publishes
 * the email sending events associated with a configuration set. For information about using configuration sets, see the
 * <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateConfigurationSetEventDestinationRequest extends SESRequest implements
        ToCopyableBuilder<CreateConfigurationSetEventDestinationRequest.Builder, CreateConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;

    private final EventDestination eventDestination;

    private CreateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
    }

    /**
     * <p>
     * The name of the configuration set that the event destination should be associated with.
     * </p>
     * 
     * @return The name of the configuration set that the event destination should be associated with.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * An object that describes the AWS service that email sending event information will be published to.
     * </p>
     * 
     * @return An object that describes the AWS service that email sending event information will be published to.
     */
    public EventDestination eventDestination() {
        return eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        CreateConfigurationSetEventDestinationRequest other = (CreateConfigurationSetEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestination(), other.eventDestination());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateConfigurationSetEventDestinationRequest")
                .add("ConfigurationSetName", configurationSetName()).add("EventDestination", eventDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.of(clazz.cast(configurationSetName()));
        case "EventDestination":
            return Optional.of(clazz.cast(eventDestination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, CreateConfigurationSetEventDestinationRequest> {
        /**
         * <p>
         * The name of the configuration set that the event destination should be associated with.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that the event destination should be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * An object that describes the AWS service that email sending event information will be published to.
         * </p>
         * 
         * @param eventDestination
         *        An object that describes the AWS service that email sending event information will be published to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestination eventDestination);

        /**
         * <p>
         * An object that describes the AWS service that email sending event information will be published to.
         * </p>
         * This is a convenience that creates an instance of the {@link EventDestination.Builder} avoiding the need to
         * create one manually via {@link EventDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #eventDestination(EventDestination)}.
         * 
         * @param eventDestination
         *        a consumer that will call methods on {@link EventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestination(EventDestination)
         */
        default Builder eventDestination(Consumer<EventDestination.Builder> eventDestination) {
            return eventDestination(EventDestination.builder().apply(eventDestination).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private EventDestination eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetEventDestinationRequest model) {
            configurationSetName(model.configurationSetName);
            eventDestination(model.eventDestination);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final EventDestination.Builder getEventDestination() {
            return eventDestination != null ? eventDestination.toBuilder() : null;
        }

        @Override
        public final Builder eventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        public final void setEventDestination(EventDestination.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetEventDestinationRequest build() {
            return new CreateConfigurationSetEventDestinationRequest(this);
        }
    }
}
