/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create an open and click tracking option object in a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateConfigurationSetTrackingOptionsRequest extends SESRequest implements
        ToCopyableBuilder<CreateConfigurationSetTrackingOptionsRequest.Builder, CreateConfigurationSetTrackingOptionsRequest> {
    private final String configurationSetName;

    private final TrackingOptions trackingOptions;

    private CreateConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
    }

    /**
     * <p>
     * The name of the configuration set that the tracking options should be associated with.
     * </p>
     * 
     * @return The name of the configuration set that the tracking options should be associated with.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * Returns the value of the TrackingOptions property for this object.
     * 
     * @return The value of the TrackingOptions property for this object.
     */
    public TrackingOptions trackingOptions() {
        return trackingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(trackingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        CreateConfigurationSetTrackingOptionsRequest other = (CreateConfigurationSetTrackingOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(trackingOptions(), other.trackingOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateConfigurationSetTrackingOptionsRequest")
                .add("ConfigurationSetName", configurationSetName()).add("TrackingOptions", trackingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.of(clazz.cast(configurationSetName()));
        case "TrackingOptions":
            return Optional.of(clazz.cast(trackingOptions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, CreateConfigurationSetTrackingOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set that the tracking options should be associated with.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that the tracking options should be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * Sets the value of the TrackingOptions property for this object.
         *
         * @param trackingOptions
         *        The new value for the TrackingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingOptions(TrackingOptions trackingOptions);

        /**
         * Sets the value of the TrackingOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrackingOptions.Builder} avoiding the need to
         * create one manually via {@link TrackingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrackingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #trackingOptions(TrackingOptions)}.
         * 
         * @param trackingOptions
         *        a consumer that will call methods on {@link TrackingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackingOptions(TrackingOptions)
         */
        default Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return trackingOptions(TrackingOptions.builder().apply(trackingOptions).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private TrackingOptions trackingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetTrackingOptionsRequest model) {
            configurationSetName(model.configurationSetName);
            trackingOptions(model.trackingOptions);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return trackingOptions != null ? trackingOptions.toBuilder() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetTrackingOptionsRequest build() {
            return new CreateConfigurationSetTrackingOptionsRequest(this);
        }
    }
}
