/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete a sending authorization policy for an identity. Sending authorization is an Amazon SES
 * feature that enables you to authorize other senders to use your identities. For information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteIdentityPolicyRequest extends SESRequest implements
        ToCopyableBuilder<DeleteIdentityPolicyRequest.Builder, DeleteIdentityPolicyRequest> {
    private final String identity;

    private final String policyName;

    private DeleteIdentityPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.policyName = builder.policyName;
    }

    /**
     * <p>
     * The identity that is associated with the policy that you want to delete. You can specify the identity by using
     * its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
     * <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     * </p>
     * <p>
     * To successfully call this API, you must own the identity.
     * </p>
     * 
     * @return The identity that is associated with the policy that you want to delete. You can specify the identity by
     *         using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
     *         <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
     *         <p>
     *         To successfully call this API, you must own the identity.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * The name of the policy to be deleted.
     * </p>
     * 
     * @return The name of the policy to be deleted.
     */
    public String policyName() {
        return policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentityPolicyRequest)) {
            return false;
        }
        DeleteIdentityPolicyRequest other = (DeleteIdentityPolicyRequest) obj;
        return Objects.equals(identity(), other.identity()) && Objects.equals(policyName(), other.policyName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteIdentityPolicyRequest").add("Identity", identity()).add("PolicyName", policyName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.of(clazz.cast(identity()));
        case "PolicyName":
            return Optional.of(clazz.cast(policyName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, DeleteIdentityPolicyRequest> {
        /**
         * <p>
         * The identity that is associated with the policy that you want to delete. You can specify the identity by
         * using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
         * <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * </p>
         * <p>
         * To successfully call this API, you must own the identity.
         * </p>
         * 
         * @param identity
         *        The identity that is associated with the policy that you want to delete. You can specify the identity
         *        by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
         *        <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
         *        <p>
         *        To successfully call this API, you must own the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * The name of the policy to be deleted.
         * </p>
         * 
         * @param policyName
         *        The name of the policy to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String identity;

        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentityPolicyRequest model) {
            identity(model.identity);
            policyName(model.policyName);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteIdentityPolicyRequest build() {
            return new DeleteIdentityPolicyRequest(this);
        }
    }
}
