/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete an email address from the list of email addresses you have attempted to verify under
 * your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteVerifiedEmailAddressRequest extends SESRequest implements
        ToCopyableBuilder<DeleteVerifiedEmailAddressRequest.Builder, DeleteVerifiedEmailAddressRequest> {
    private final String emailAddress;

    private DeleteVerifiedEmailAddressRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
    }

    /**
     * <p>
     * An email address to be removed from the list of verified addresses.
     * </p>
     * 
     * @return An email address to be removed from the list of verified addresses.
     */
    public String emailAddress() {
        return emailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVerifiedEmailAddressRequest)) {
            return false;
        }
        DeleteVerifiedEmailAddressRequest other = (DeleteVerifiedEmailAddressRequest) obj;
        return Objects.equals(emailAddress(), other.emailAddress());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteVerifiedEmailAddressRequest").add("EmailAddress", emailAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.of(clazz.cast(emailAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, DeleteVerifiedEmailAddressRequest> {
        /**
         * <p>
         * An email address to be removed from the list of verified addresses.
         * </p>
         * 
         * @param emailAddress
         *        An email address to be removed from the list of verified addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVerifiedEmailAddressRequest model) {
            emailAddress(model.emailAddress);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteVerifiedEmailAddressRequest build() {
            return new DeleteVerifiedEmailAddressRequest(this);
        }
    }
}
