/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that a template could not be created because it contained invalid JSON.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidTemplateException extends SESException implements
        ToCopyableBuilder<InvalidTemplateException.Builder, InvalidTemplateException> {
    private final String templateName;

    private InvalidTemplateException(BuilderImpl builder) {
        super(builder.message);
        this.templateName = builder.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the TemplateName property for this object.
     * 
     * @return The value of the TemplateName property for this object.
     */
    public String templateName() {
        return templateName;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidTemplateException> {
        /**
         * Sets the value of the TemplateName property for this object.
         *
         * @param templateName
         *        The new value for the TemplateName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidTemplateException model) {
            templateName(model.templateName);
            this.message = model.getMessage();
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidTemplateException build() {
            return new InvalidTemplateException(this);
        }
    }
}
