/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action calls an AWS Lambda function and, optionally, publishes a notification
 * to Amazon Simple Notification Service (Amazon SNS).
 * </p>
 * <p>
 * To enable Amazon SES to call your AWS Lambda function or to publish to an Amazon SNS topic of another account, Amazon
 * SES must have permission to access those resources. For information about giving permissions, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 * <p>
 * For information about using AWS Lambda actions in receipt rules, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaAction implements ToCopyableBuilder<LambdaAction.Builder, LambdaAction> {
    private final String topicArn;

    private final String functionArn;

    private final String invocationType;

    private LambdaAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.functionArn = builder.functionArn;
        this.invocationType = builder.invocationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An example of
     * an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     * Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     * Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An
     *         example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
     *         information about Amazon SNS topics, see the <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
     * <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS Lambda, see
     * the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
     *         <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS
     *         Lambda, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer
     *         Guide</a>.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that the
     * execution of the function will immediately result in a response, and a value of <code>Event</code> means that the
     * function will be invoked asynchronously. The default value is <code>Event</code>. For information about AWS
     * Lambda invocation types, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda
     * Developer Guide</a>.
     * </p>
     * <important>
     * <p>
     * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
     * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision, such
     * as whether to stop the receipt rule or the receipt rule set.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeString}.
     * </p>
     * 
     * @return The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means
     *         that the execution of the function will immediately result in a response, and a value of
     *         <code>Event</code> means that the function will be invoked asynchronously. The default value is
     *         <code>Event</code>. For information about AWS Lambda invocation types, see the <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
     *         <important>
     *         <p>
     *         There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
     *         <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to make
     *         a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
     *         </p>
     * @see InvocationType
     */
    public InvocationType invocationType() {
        return InvocationType.fromValue(invocationType);
    }

    /**
     * <p>
     * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that the
     * execution of the function will immediately result in a response, and a value of <code>Event</code> means that the
     * function will be invoked asynchronously. The default value is <code>Event</code>. For information about AWS
     * Lambda invocation types, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda
     * Developer Guide</a>.
     * </p>
     * <important>
     * <p>
     * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
     * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision, such
     * as whether to stop the receipt rule or the receipt rule set.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeString}.
     * </p>
     * 
     * @return The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means
     *         that the execution of the function will immediately result in a response, and a value of
     *         <code>Event</code> means that the function will be invoked asynchronously. The default value is
     *         <code>Event</code>. For information about AWS Lambda invocation types, see the <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
     *         <important>
     *         <p>
     *         There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
     *         <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to make
     *         a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
     *         </p>
     * @see InvocationType
     */
    public String invocationTypeString() {
        return invocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(invocationTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaAction)) {
            return false;
        }
        LambdaAction other = (LambdaAction) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(invocationTypeString(), other.invocationTypeString());
    }

    @Override
    public String toString() {
        return ToString.builder("LambdaAction").add("TopicArn", topicArn()).add("FunctionArn", functionArn())
                .add("InvocationType", invocationTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        case "FunctionArn":
            return Optional.of(clazz.cast(functionArn()));
        case "InvocationType":
            return Optional.of(clazz.cast(invocationTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An example
         * of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information
         * about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon
         * SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An
         *        example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
         *        more information about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
         * <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS Lambda,
         * see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
         *        <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS
         *        Lambda, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that
         * the execution of the function will immediately result in a response, and a value of <code>Event</code> means
         * that the function will be invoked asynchronously. The default value is <code>Event</code>. For information
         * about AWS Lambda invocation types, see the <a
         * href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.
         * </p>
         * <important>
         * <p>
         * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
         * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision,
         * such as whether to stop the receipt rule or the receipt rule set.
         * </p>
         * </important>
         * 
         * @param invocationType
         *        The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code>
         *        means that the execution of the function will immediately result in a response, and a value of
         *        <code>Event</code> means that the function will be invoked asynchronously. The default value is
         *        <code>Event</code>. For information about AWS Lambda invocation types, see the <a
         *        href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
         *        <important>
         *        <p>
         *        There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
         *        <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to
         *        make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
         *        </p>
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that
         * the execution of the function will immediately result in a response, and a value of <code>Event</code> means
         * that the function will be invoked asynchronously. The default value is <code>Event</code>. For information
         * about AWS Lambda invocation types, see the <a
         * href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.
         * </p>
         * <important>
         * <p>
         * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
         * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision,
         * such as whether to stop the receipt rule or the receipt rule set.
         * </p>
         * </important>
         * 
         * @param invocationType
         *        The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code>
         *        means that the execution of the function will immediately result in a response, and a value of
         *        <code>Event</code> means that the function will be invoked asynchronously. The default value is
         *        <code>Event</code>. For information about AWS Lambda invocation types, see the <a
         *        href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
         *        <important>
         *        <p>
         *        There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
         *        <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to
         *        make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
         *        </p>
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(InvocationType invocationType);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String functionArn;

        private String invocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaAction model) {
            topicArn(model.topicArn);
            functionArn(model.functionArn);
            invocationType(model.invocationType);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getInvocationType() {
            return invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType.toString());
            return this;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public LambdaAction build() {
            return new LambdaAction(this);
        }
    }
}
