/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of receipt rule sets that exist under your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListReceiptRuleSetsResponse extends SESResponse implements
        ToCopyableBuilder<ListReceiptRuleSetsResponse.Builder, ListReceiptRuleSetsResponse> {
    private final List<ReceiptRuleSetMetadata> ruleSets;

    private final String nextToken;

    private ListReceiptRuleSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSets = builder.ruleSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
     * timestamp of when the rule set was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
     *         the timestamp of when the rule set was created.
     */
    public List<ReceiptRuleSetMetadata> ruleSets() {
        return ruleSets;
    }

    /**
     * <p>
     * A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
     * successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
     * </p>
     * 
     * @return A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
     *         successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleSets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptRuleSetsResponse)) {
            return false;
        }
        ListReceiptRuleSetsResponse other = (ListReceiptRuleSetsResponse) obj;
        return Objects.equals(ruleSets(), other.ruleSets()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListReceiptRuleSetsResponse").add("RuleSets", ruleSets()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSets":
            return Optional.of(clazz.cast(ruleSets()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, ListReceiptRuleSetsResponse> {
        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * 
         * @param ruleSets
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        the timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets);

        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * 
         * @param ruleSets
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        the timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(ReceiptRuleSetMetadata... ruleSets);

        /**
         * <p>
         * A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
         * successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional receipt rule sets available to be listed. Pass this token
         *        to successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private List<ReceiptRuleSetMetadata> ruleSets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptRuleSetsResponse model) {
            ruleSets(model.ruleSets);
            nextToken(model.nextToken);
        }

        public final Collection<ReceiptRuleSetMetadata.Builder> getRuleSets() {
            return ruleSets != null ? ruleSets.stream().map(ReceiptRuleSetMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(ReceiptRuleSetMetadata... ruleSets) {
            ruleSets(Arrays.asList(ruleSets));
            return this;
        }

        public final void setRuleSets(Collection<ReceiptRuleSetMetadata.BuilderImpl> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copyFromBuilder(ruleSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReceiptRuleSetsResponse build() {
            return new ListReceiptRuleSetsResponse(this);
        }
    }
}
