/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTemplatesRequest extends SESRequest implements
        ToCopyableBuilder<ListTemplatesRequest.Builder, ListTemplatesRequest> {
    private final String nextToken;

    private final Integer maxItems;

    private ListTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The token to use for pagination.
     * </p>
     * 
     * @return The token to use for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If you do
     * not specify a value, or if you specify a value less than 1 or greater than 10, the operation will return up to 10
     * results.
     * </p>
     * 
     * @return The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If
     *         you do not specify a value, or if you specify a value less than 1 or greater than 10, the operation will
     *         return up to 10 results.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesRequest)) {
            return false;
        }
        ListTemplatesRequest other = (ListTemplatesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTemplatesRequest").add("NextToken", nextToken()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, ListTemplatesRequest> {
        /**
         * <p>
         * The token to use for pagination.
         * </p>
         * 
         * @param nextToken
         *        The token to use for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If you
         * do not specify a value, or if you specify a value less than 1 or greater than 10, the operation will return
         * up to 10 results.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of templates to return. This value must be at least 1 and less than or equal to 10.
         *        If you do not specify a value, or if you specify a value less than 1 or greater than 10, the operation
         *        will return up to 10 results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesRequest model) {
            nextToken(model.nextToken);
            maxItems(model.maxItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTemplatesRequest build() {
            return new ListTemplatesRequest(this);
        }
    }
}
