/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to modify the reputation metric publishing settings for a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateConfigurationSetReputationMetricsEnabledRequest extends SESRequest
        implements
        ToCopyableBuilder<UpdateConfigurationSetReputationMetricsEnabledRequest.Builder, UpdateConfigurationSetReputationMetricsEnabledRequest> {
    private final String configurationSetName;

    private final Boolean enabled;

    private UpdateConfigurationSetReputationMetricsEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The name of the configuration set that you want to update.
     * </p>
     * 
     * @return The name of the configuration set that you want to update.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as bounce and
     * complaint rates, to Amazon CloudWatch.
     * </p>
     * 
     * @return Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as
     *         bounce and complaint rates, to Amazon CloudWatch.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetReputationMetricsEnabledRequest)) {
            return false;
        }
        UpdateConfigurationSetReputationMetricsEnabledRequest other = (UpdateConfigurationSetReputationMetricsEnabledRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName()) && Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateConfigurationSetReputationMetricsEnabledRequest")
                .add("ConfigurationSetName", configurationSetName()).add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.of(clazz.cast(configurationSetName()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder,
            CopyableBuilder<Builder, UpdateConfigurationSetReputationMetricsEnabledRequest> {
        /**
         * <p>
         * The name of the configuration set that you want to update.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as bounce
         * and complaint rates, to Amazon CloudWatch.
         * </p>
         * 
         * @param enabled
         *        Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as
         *        bounce and complaint rates, to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetReputationMetricsEnabledRequest model) {
            configurationSetName(model.configurationSetName);
            enabled(model.enabled);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetReputationMetricsEnabledRequest build() {
            return new UpdateConfigurationSetReputationMetricsEnabledRequest(this);
        }
    }
}
