/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * BouncedRecipientInfo StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BouncedRecipientInfoUnmarshaller implements Unmarshaller<BouncedRecipientInfo, StaxUnmarshallerContext> {

    public BouncedRecipientInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        BouncedRecipientInfo.Builder bouncedRecipientInfo = BouncedRecipientInfo.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Recipient", targetDepth)) {
                    bouncedRecipientInfo.recipient(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecipientArn", targetDepth)) {
                    bouncedRecipientInfo.recipientArn(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BounceType", targetDepth)) {
                    bouncedRecipientInfo.bounceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecipientDsnFields", targetDepth)) {
                    bouncedRecipientInfo.recipientDsnFields(RecipientDsnFieldsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return bouncedRecipientInfo.build();
    }

    private static final BouncedRecipientInfoUnmarshaller INSTANCE = new BouncedRecipientInfoUnmarshaller();

    public static BouncedRecipientInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}
