/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CloudWatchDestination StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CloudWatchDestinationUnmarshaller implements Unmarshaller<CloudWatchDestination, StaxUnmarshallerContext> {

    public CloudWatchDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudWatchDestination.Builder cloudWatchDestination = CloudWatchDestination.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<CloudWatchDimensionConfiguration> dimensionConfigurations = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                cloudWatchDestination.dimensionConfigurations(dimensionConfigurations);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DimensionConfigurations", targetDepth)) {
                    dimensionConfigurations = new ArrayList<CloudWatchDimensionConfiguration>();
                    continue;
                }

                if (context.testExpression("DimensionConfigurations/member", targetDepth)) {
                    dimensionConfigurations.add(CloudWatchDimensionConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    cloudWatchDestination.dimensionConfigurations(dimensionConfigurations);
                    break;
                }
            }
        }
        return cloudWatchDestination.build();
    }

    private static final CloudWatchDestinationUnmarshaller INSTANCE = new CloudWatchDestinationUnmarshaller();

    public static CloudWatchDestinationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
