/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetIdentityPoliciesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityPoliciesResponseUnmarshaller implements
        Unmarshaller<GetIdentityPoliciesResponse, StaxUnmarshallerContext> {

    private static class PoliciesMapEntryUnmarshaller implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final PoliciesMapEntryUnmarshaller INSTANCE = new PoliciesMapEntryUnmarshaller();

        public static PoliciesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public GetIdentityPoliciesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetIdentityPoliciesResponse.Builder getIdentityPoliciesResponse = GetIdentityPoliciesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.Map<String, String> policies = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getIdentityPoliciesResponse.policies(policies);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Policies/entry", targetDepth)) {
                    if (policies == null) {
                        policies = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = PoliciesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    // getIdentityPoliciesResponse.addPoliciesEntry(entry.getKey(), entry.getValue());

                    policies.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getIdentityPoliciesResponse.policies(policies);
                    break;
                }
            }
        }
        return getIdentityPoliciesResponse.build();
    }

    private static final GetIdentityPoliciesResponseUnmarshaller INSTANCE = new GetIdentityPoliciesResponseUnmarshaller();

    public static GetIdentityPoliciesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
