/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * SendBounceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendBounceRequestMarshaller implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {

    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {

        if (sendBounceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SendBounceRequest> request = new DefaultRequest<SendBounceRequest>(sendBounceRequest, "SESClient");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendBounceRequest.originalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringUtils.fromString(sendBounceRequest.originalMessageId()));
        }

        if (sendBounceRequest.bounceSender() != null) {
            request.addParameter("BounceSender", StringUtils.fromString(sendBounceRequest.bounceSender()));
        }

        if (sendBounceRequest.explanation() != null) {
            request.addParameter("Explanation", StringUtils.fromString(sendBounceRequest.explanation()));
        }

        MessageDsn messageDsn = sendBounceRequest.messageDsn();
        if (messageDsn != null) {

            if (messageDsn.reportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringUtils.fromString(messageDsn.reportingMta()));
            }

            if (messageDsn.arrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringUtils.fromInstant(messageDsn.arrivalDate()));
            }

            java.util.List<ExtensionField> extensionFieldsList = messageDsn.extensionFields();

            if (extensionFieldsList != null) {
                if (!extensionFieldsList.isEmpty()) {
                    int extensionFieldsListIndex = 1;

                    for (ExtensionField extensionFieldsListValue : extensionFieldsList) {

                        if (extensionFieldsListValue.name() != null) {
                            request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name",
                                    StringUtils.fromString(extensionFieldsListValue.name()));
                        }

                        if (extensionFieldsListValue.value() != null) {
                            request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value",
                                    StringUtils.fromString(extensionFieldsListValue.value()));
                        }
                        extensionFieldsListIndex++;
                    }
                } else {
                    request.addParameter("MessageDsn.ExtensionFields", "");
                }
            }
        }

        java.util.List<BouncedRecipientInfo> bouncedRecipientInfoListList = sendBounceRequest.bouncedRecipientInfoList();

        if (bouncedRecipientInfoListList != null) {
            if (!bouncedRecipientInfoListList.isEmpty()) {
                int bouncedRecipientInfoListListIndex = 1;

                for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {

                    if (bouncedRecipientInfoListListValue.recipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".Recipient", StringUtils.fromString(bouncedRecipientInfoListListValue.recipient()));
                    }

                    if (bouncedRecipientInfoListListValue.recipientArn() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientArn", StringUtils.fromString(bouncedRecipientInfoListListValue.recipientArn()));
                    }

                    if (bouncedRecipientInfoListListValue.bounceTypeString() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".BounceType", StringUtils.fromString(bouncedRecipientInfoListListValue.bounceTypeString()));
                    }

                    RecipientDsnFields recipientDsnFields = bouncedRecipientInfoListListValue.recipientDsnFields();
                    if (recipientDsnFields != null) {

                        if (recipientDsnFields.finalRecipient() != null) {
                            request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                    + ".RecipientDsnFields.FinalRecipient",
                                    StringUtils.fromString(recipientDsnFields.finalRecipient()));
                        }

                        if (recipientDsnFields.actionString() != null) {
                            request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                    + ".RecipientDsnFields.Action", StringUtils.fromString(recipientDsnFields.actionString()));
                        }

                        if (recipientDsnFields.remoteMta() != null) {
                            request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                    + ".RecipientDsnFields.RemoteMta", StringUtils.fromString(recipientDsnFields.remoteMta()));
                        }

                        if (recipientDsnFields.status() != null) {
                            request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                    + ".RecipientDsnFields.Status", StringUtils.fromString(recipientDsnFields.status()));
                        }

                        if (recipientDsnFields.diagnosticCode() != null) {
                            request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                    + ".RecipientDsnFields.DiagnosticCode",
                                    StringUtils.fromString(recipientDsnFields.diagnosticCode()));
                        }

                        if (recipientDsnFields.lastAttemptDate() != null) {
                            request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                    + ".RecipientDsnFields.LastAttemptDate",
                                    StringUtils.fromInstant(recipientDsnFields.lastAttemptDate()));
                        }

                        java.util.List<ExtensionField> extensionFieldsList = recipientDsnFields.extensionFields();

                        if (extensionFieldsList != null) {
                            if (!extensionFieldsList.isEmpty()) {
                                int extensionFieldsListIndex = 1;

                                for (ExtensionField extensionFieldsListValue : extensionFieldsList) {

                                    if (extensionFieldsListValue.name() != null) {
                                        request.addParameter("BouncedRecipientInfoList.member."
                                                + bouncedRecipientInfoListListIndex
                                                + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex
                                                + ".Name", StringUtils.fromString(extensionFieldsListValue.name()));
                                    }

                                    if (extensionFieldsListValue.value() != null) {
                                        request.addParameter("BouncedRecipientInfoList.member."
                                                + bouncedRecipientInfoListListIndex
                                                + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex
                                                + ".Value", StringUtils.fromString(extensionFieldsListValue.value()));
                                    }
                                    extensionFieldsListIndex++;
                                }
                            } else {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                        + ".RecipientDsnFields.ExtensionFields", "");
                            }
                        }
                    }
                    bouncedRecipientInfoListListIndex++;
                }
            } else {
                request.addParameter("BouncedRecipientInfoList", "");
            }
        }

        if (sendBounceRequest.bounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringUtils.fromString(sendBounceRequest.bounceSenderArn()));
        }

        return request;
    }

}
