/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes;
import software.amazon.awssdk.services.ses.model.NotificationAttributesCopier;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityNotificationAttributesResponse
extends SESResponse
implements ToCopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.notificationAttributes = builder.notificationAttributes;
    }

    public Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return this.notificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse)((Object)obj);
        return Objects.equals(this.notificationAttributes(), other.notificationAttributes());
    }

    public String toString() {
        return ToString.builder((String)"GetIdentityNotificationAttributesResponse").add("NotificationAttributes", this.notificationAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationAttributes": {
                return Optional.of(clazz.cast(this.notificationAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            this.notificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes.Builder> getNotificationAttributes() {
            return this.notificationAttributes != null ? CollectionUtils.mapValues(this.notificationAttributes, IdentityNotificationAttributes::toBuilder) : null;
        }

        @Override
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes.BuilderImpl> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copyFromBuilder(notificationAttributes);
        }

        @Override
        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        public Builder notificationAttributes(Map<String, IdentityNotificationAttributes> var1);
    }
}

