/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.ReceiptFilter;
import software.amazon.awssdk.services.ses.model.ReceiptFilterListCopier;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListReceiptFiltersResponse
extends SESResponse
implements ToCopyableBuilder<Builder, ListReceiptFiltersResponse> {
    private final List<ReceiptFilter> filters;

    private ListReceiptFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
    }

    public List<ReceiptFilter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptFiltersResponse)) {
            return false;
        }
        ListReceiptFiltersResponse other = (ListReceiptFiltersResponse)((Object)obj);
        return Objects.equals(this.filters(), other.filters());
    }

    public String toString() {
        return ToString.builder((String)"ListReceiptFiltersResponse").add("Filters", this.filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private List<ReceiptFilter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptFiltersResponse model) {
            this.filters(model.filters);
        }

        public final Collection<ReceiptFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ReceiptFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ReceiptFilter> filters) {
            this.filters = ReceiptFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ReceiptFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<ReceiptFilter.BuilderImpl> filters) {
            this.filters = ReceiptFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public ListReceiptFiltersResponse build() {
            return new ListReceiptFiltersResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, ListReceiptFiltersResponse> {
        public Builder filters(Collection<ReceiptFilter> var1);

        public Builder filters(ReceiptFilter ... var1);
    }
}

