/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetIdentityMailFromDomainRequest
extends SESRequest
implements ToCopyableBuilder<Builder, SetIdentityMailFromDomainRequest> {
    private final String identity;
    private final String mailFromDomain;
    private final String behaviorOnMXFailure;

    private SetIdentityMailFromDomainRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.mailFromDomain = builder.mailFromDomain;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    public String identity() {
        return this.identity;
    }

    public String mailFromDomain() {
        return this.mailFromDomain;
    }

    public BehaviorOnMXFailure behaviorOnMXFailure() {
        return BehaviorOnMXFailure.fromValue(this.behaviorOnMXFailure);
    }

    public String behaviorOnMXFailureString() {
        return this.behaviorOnMXFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorOnMXFailureString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityMailFromDomainRequest)) {
            return false;
        }
        SetIdentityMailFromDomainRequest other = (SetIdentityMailFromDomainRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.mailFromDomain(), other.mailFromDomain()) && Objects.equals(this.behaviorOnMXFailureString(), other.behaviorOnMXFailureString());
    }

    public String toString() {
        return ToString.builder((String)"SetIdentityMailFromDomainRequest").add("Identity", (Object)this.identity()).add("MailFromDomain", (Object)this.mailFromDomain()).add("BehaviorOnMXFailure", (Object)this.behaviorOnMXFailureString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "MailFromDomain": {
                return Optional.of(clazz.cast(this.mailFromDomain()));
            }
            case "BehaviorOnMXFailure": {
                return Optional.of(clazz.cast(this.behaviorOnMXFailureString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String identity;
        private String mailFromDomain;
        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityMailFromDomainRequest model) {
            this.identity(model.identity);
            this.mailFromDomain(model.mailFromDomain);
            this.behaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getMailFromDomain() {
            return this.mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getBehaviorOnMXFailure() {
            return this.behaviorOnMXFailure;
        }

        @Override
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
            return this;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityMailFromDomainRequest build() {
            return new SetIdentityMailFromDomainRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, SetIdentityMailFromDomainRequest> {
        public Builder identity(String var1);

        public Builder mailFromDomain(String var1);

        public Builder behaviorOnMXFailure(String var1);

        public Builder behaviorOnMXFailure(BehaviorOnMXFailure var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

