/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a list of data points. This list contains aggregated data from the previous two weeks of your sending
 * activity with Amazon SES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSendStatisticsResponse extends SesResponse implements
        ToCopyableBuilder<GetSendStatisticsResponse.Builder, GetSendStatisticsResponse> {
    private static final SdkField<List<SendDataPoint>> SEND_DATA_POINTS_FIELD = SdkField
            .<List<SendDataPoint>> builder(MarshallingType.LIST)
            .getter(getter(GetSendStatisticsResponse::sendDataPoints))
            .setter(setter(Builder::sendDataPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendDataPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SendDataPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(SendDataPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_DATA_POINTS_FIELD));

    private final List<SendDataPoint> sendDataPoints;

    private GetSendStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.sendDataPoints = builder.sendDataPoints;
    }

    /**
     * <p>
     * A list of data points, each of which represents 15 minutes of activity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of data points, each of which represents 15 minutes of activity.
     */
    public List<SendDataPoint> sendDataPoints() {
        return sendDataPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sendDataPoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendStatisticsResponse)) {
            return false;
        }
        GetSendStatisticsResponse other = (GetSendStatisticsResponse) obj;
        return Objects.equals(sendDataPoints(), other.sendDataPoints());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSendStatisticsResponse").add("SendDataPoints", sendDataPoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendDataPoints":
            return Optional.ofNullable(clazz.cast(sendDataPoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSendStatisticsResponse, T> g) {
        return obj -> g.apply((GetSendStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSendStatisticsResponse> {
        /**
         * <p>
         * A list of data points, each of which represents 15 minutes of activity.
         * </p>
         * 
         * @param sendDataPoints
         *        A list of data points, each of which represents 15 minutes of activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendDataPoints(Collection<SendDataPoint> sendDataPoints);

        /**
         * <p>
         * A list of data points, each of which represents 15 minutes of activity.
         * </p>
         * 
         * @param sendDataPoints
         *        A list of data points, each of which represents 15 minutes of activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendDataPoints(SendDataPoint... sendDataPoints);

        /**
         * <p>
         * A list of data points, each of which represents 15 minutes of activity.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SendDataPoint>.Builder} avoiding the need
         * to create one manually via {@link List<SendDataPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SendDataPoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #sendDataPoints(List<SendDataPoint>)}.
         * 
         * @param sendDataPoints
         *        a consumer that will call methods on {@link List<SendDataPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sendDataPoints(List<SendDataPoint>)
         */
        Builder sendDataPoints(Consumer<SendDataPoint.Builder>... sendDataPoints);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<SendDataPoint> sendDataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendStatisticsResponse model) {
            super(model);
            sendDataPoints(model.sendDataPoints);
        }

        public final Collection<SendDataPoint.Builder> getSendDataPoints() {
            return sendDataPoints != null ? sendDataPoints.stream().map(SendDataPoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder sendDataPoints(Collection<SendDataPoint> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copy(sendDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(SendDataPoint... sendDataPoints) {
            sendDataPoints(Arrays.asList(sendDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(Consumer<SendDataPoint.Builder>... sendDataPoints) {
            sendDataPoints(Stream.of(sendDataPoints).map(c -> SendDataPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSendDataPoints(Collection<SendDataPoint.BuilderImpl> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copyFromBuilder(sendDataPoints);
        }

        @Override
        public GetSendStatisticsResponse build() {
            return new GetSendStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
