/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action rejects the received email by returning a bounce response to the sender
 * and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
 * </p>
 * <p>
 * For information about sending a bounce message in response to a received email, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BounceAction implements SdkPojo, Serializable, ToCopyableBuilder<BounceAction.Builder, BounceAction> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BounceAction::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> SMTP_REPLY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BounceAction::smtpReplyCode)).setter(setter(Builder::smtpReplyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmtpReplyCode").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BounceAction::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BounceAction::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> SENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BounceAction::sender)).setter(setter(Builder::sender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            SMTP_REPLY_CODE_FIELD, STATUS_CODE_FIELD, MESSAGE_FIELD, SENDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topicArn;

    private final String smtpReplyCode;

    private final String statusCode;

    private final String message;

    private final String sender;

    private BounceAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.smtpReplyCode = builder.smtpReplyCode;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.sender = builder.sender;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An example of
     * an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     * Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     * Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An
     *         example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
     *         information about Amazon SNS topics, see the <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     * </p>
     * 
     * @return The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     */
    public String smtpReplyCode() {
        return smtpReplyCode;
    }

    /**
     * <p>
     * The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.
     * </p>
     * 
     * @return The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.
     */
    public String statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * Human-readable text to include in the bounce message.
     * </p>
     * 
     * @return Human-readable text to include in the bounce message.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The email address of the sender of the bounced email. This is the address from which the bounce message will be
     * sent.
     * </p>
     * 
     * @return The email address of the sender of the bounced email. This is the address from which the bounce message
     *         will be sent.
     */
    public String sender() {
        return sender;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(smtpReplyCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BounceAction)) {
            return false;
        }
        BounceAction other = (BounceAction) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(smtpReplyCode(), other.smtpReplyCode())
                && Objects.equals(statusCode(), other.statusCode()) && Objects.equals(message(), other.message())
                && Objects.equals(sender(), other.sender());
    }

    @Override
    public String toString() {
        return ToString.builder("BounceAction").add("TopicArn", topicArn()).add("SmtpReplyCode", smtpReplyCode())
                .add("StatusCode", statusCode()).add("Message", message()).add("Sender", sender()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "SmtpReplyCode":
            return Optional.ofNullable(clazz.cast(smtpReplyCode()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BounceAction, T> g) {
        return obj -> g.apply((BounceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BounceAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An example
         * of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information
         * about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon
         * SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An
         *        example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
         *        more information about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * </p>
         * 
         * @param smtpReplyCode
         *        The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smtpReplyCode(String smtpReplyCode);

        /**
         * <p>
         * The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.
         * </p>
         * 
         * @param statusCode
         *        The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC
         *        3463</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Human-readable text to include in the bounce message.
         * </p>
         * 
         * @param message
         *        Human-readable text to include in the bounce message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The email address of the sender of the bounced email. This is the address from which the bounce message will
         * be sent.
         * </p>
         * 
         * @param sender
         *        The email address of the sender of the bounced email. This is the address from which the bounce
         *        message will be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String smtpReplyCode;

        private String statusCode;

        private String message;

        private String sender;

        private BuilderImpl() {
        }

        private BuilderImpl(BounceAction model) {
            topicArn(model.topicArn);
            smtpReplyCode(model.smtpReplyCode);
            statusCode(model.statusCode);
            message(model.message);
            sender(model.sender);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getSmtpReplyCode() {
            return smtpReplyCode;
        }

        @Override
        public final Builder smtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
            return this;
        }

        public final void setSmtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSender() {
            return sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public BounceAction build() {
            return new BounceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
