/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ses.model.AccountSendingPausedException;
import software.amazon.awssdk.services.ses.model.AlreadyExistsException;
import software.amazon.awssdk.services.ses.model.CannotDeleteException;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.ConfigurationSetDoesNotExistException;
import software.amazon.awssdk.services.ses.model.ConfigurationSetSendingPausedException;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.CreateTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateTemplateResponse;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailInvalidContentException;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplateAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplateDoesNotExistException;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.EventDestinationAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.EventDestinationDoesNotExistException;
import software.amazon.awssdk.services.ses.model.FromEmailAddressNotVerifiedException;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetSendQuotaRequest;
import software.amazon.awssdk.services.ses.model.GetSendQuotaResponse;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsRequest;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse;
import software.amazon.awssdk.services.ses.model.GetTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetTemplateResponse;
import software.amazon.awssdk.services.ses.model.InvalidCloudWatchDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidConfigurationSetException;
import software.amazon.awssdk.services.ses.model.InvalidFirehoseDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidLambdaFunctionException;
import software.amazon.awssdk.services.ses.model.InvalidPolicyException;
import software.amazon.awssdk.services.ses.model.InvalidRenderingParameterException;
import software.amazon.awssdk.services.ses.model.InvalidS3ConfigurationException;
import software.amazon.awssdk.services.ses.model.InvalidSnsDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidSnsTopicException;
import software.amazon.awssdk.services.ses.model.InvalidTemplateException;
import software.amazon.awssdk.services.ses.model.InvalidTrackingOptionsException;
import software.amazon.awssdk.services.ses.model.LimitExceededException;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse;
import software.amazon.awssdk.services.ses.model.ListTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesRequest;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse;
import software.amazon.awssdk.services.ses.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.ses.model.MessageRejectedException;
import software.amazon.awssdk.services.ses.model.MissingRenderingAttributeException;
import software.amazon.awssdk.services.ses.model.ProductionAccessNotGrantedException;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.RuleDoesNotExistException;
import software.amazon.awssdk.services.ses.model.RuleSetDoesNotExistException;
import software.amazon.awssdk.services.ses.model.SendBounceRequest;
import software.amazon.awssdk.services.ses.model.SendBounceResponse;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SesException;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicResponse;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionResponse;
import software.amazon.awssdk.services.ses.model.TemplateDoesNotExistException;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse;
import software.amazon.awssdk.services.ses.model.TrackingOptionsAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.TrackingOptionsDoesNotExistException;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityResponse;
import software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable;
import software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable;

/**
 * Service client for accessing Amazon SES. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Simple Email Service</fullname>
 * <p>
 * This document contains reference information for the <a href="https://aws.amazon.com/ses/">Amazon Simple Email
 * Service</a> (Amazon SES) API, version 2010-12-01. This document is best used in conjunction with the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html">Amazon SES Developer Guide</a>.
 * </p>
 * <note>
 * <p>
 * For a list of Amazon SES endpoints to use in service requests, see <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/regions.html">Regions and Amazon SES</a> in the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html">Amazon SES Developer Guide</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SesClient extends SdkClient {
    String SERVICE_NAME = "ses";

    /**
     * Create a {@link SesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SesClient}.
     */
    static SesClientBuilder builder() {
        return new DefaultSesClientBuilder();
    }

    /**
     * <p>
     * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new
     * receipt rule set and are completely independent of the source rule set.
     * </p>
     * <p>
     * For information about setting up rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param cloneReceiptRuleSetRequest
     *        Represents a request to create a receipt rule set by cloning an existing one. You use receipt rule sets to
     *        receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CloneReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CloneReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CloneReceiptRuleSetResponse cloneReceiptRuleSet(CloneReceiptRuleSetRequest cloneReceiptRuleSetRequest)
            throws RuleSetDoesNotExistException, AlreadyExistsException, LimitExceededException, AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new
     * receipt rule set and are completely independent of the source rule set.
     * </p>
     * <p>
     * For information about setting up rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloneReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link CloneReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param cloneReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link CloneReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to create a receipt rule set by cloning an existing one. You use receipt
     *        rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CloneReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CloneReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CloneReceiptRuleSetResponse cloneReceiptRuleSet(
            Consumer<CloneReceiptRuleSetRequest.Builder> cloneReceiptRuleSetRequest) throws RuleSetDoesNotExistException,
            AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        return cloneReceiptRuleSet(CloneReceiptRuleSetRequest.builder().applyMutation(cloneReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Creates a configuration set.
     * </p>
     * <p>
     * Configuration sets enable you to publish email sending events. For information about using configuration sets,
     * see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createConfigurationSetRequest
     *        Represents a request to create a configuration set. Configuration sets enable you to publish email sending
     *        events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws ConfigurationSetAlreadyExistsException
     *         Indicates that the configuration set could not be created because of a naming conflict.
     * @throws InvalidConfigurationSetException
     *         Indicates that the configuration set is invalid. See the error message for details.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest)
            throws ConfigurationSetAlreadyExistsException, InvalidConfigurationSetException, LimitExceededException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration set.
     * </p>
     * <p>
     * Configuration sets enable you to publish email sending events. For information about using configuration sets,
     * see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetRequest.Builder} to create a
     *        request. Represents a request to create a configuration set. Configuration sets enable you to publish
     *        email sending events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws ConfigurationSetAlreadyExistsException
     *         Indicates that the configuration set could not be created because of a naming conflict.
     * @throws InvalidConfigurationSetException
     *         Indicates that the configuration set is invalid. See the error message for details.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest)
            throws ConfigurationSetAlreadyExistsException, InvalidConfigurationSetException, LimitExceededException,
            AwsServiceException, SdkClientException, SesException {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a configuration set event destination.
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a
     * configuration set. For information about using configuration sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        Represents a request to create a configuration set event destination. A configuration set event
     *        destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS service in
     *        which Amazon SES publishes the email sending events associated with a configuration set. For information
     *        about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateConfigurationSetEventDestination operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws EventDestinationAlreadyExistsException
     *         Indicates that the event destination could not be created because of a naming conflict.
     * @throws InvalidCloudWatchDestinationException
     *         Indicates that the Amazon CloudWatch destination is invalid. See the error message for details.
     * @throws InvalidFirehoseDestinationException
     *         Indicates that the Amazon Kinesis Firehose destination is invalid. See the error message for details.
     * @throws InvalidSnsDestinationException
     *         Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error
     *         message for details.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest)
            throws ConfigurationSetDoesNotExistException, EventDestinationAlreadyExistsException,
            InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException,
            LimitExceededException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration set event destination.
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a
     * configuration set. For information about using configuration sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Represents a request to create a configuration set event destination. A configuration
     *        set event destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS
     *        service in which Amazon SES publishes the email sending events associated with a configuration set. For
     *        information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateConfigurationSetEventDestination operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws EventDestinationAlreadyExistsException
     *         Indicates that the event destination could not be created because of a naming conflict.
     * @throws InvalidCloudWatchDestinationException
     *         Indicates that the Amazon CloudWatch destination is invalid. See the error message for details.
     * @throws InvalidFirehoseDestinationException
     *         Indicates that the Amazon Kinesis Firehose destination is invalid. See the error message for details.
     * @throws InvalidSnsDestinationException
     *         Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error
     *         message for details.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(
            Consumer<CreateConfigurationSetEventDestinationRequest.Builder> createConfigurationSetEventDestinationRequest)
            throws ConfigurationSetDoesNotExistException, EventDestinationAlreadyExistsException,
            InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException,
            LimitExceededException, AwsServiceException, SdkClientException, SesException {
        return createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(createConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Creates an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     *
     * @param createConfigurationSetTrackingOptionsRequest
     *        Represents a request to create an open and click tracking option object in a configuration set.
     * @return Result of the CreateConfigurationSetTrackingOptions operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TrackingOptionsAlreadyExistsException
     *         Indicates that the configuration set you specified already contains a TrackingOptions object.
     * @throws InvalidTrackingOptionsException
     *         Indicates that the custom domain to be used for open and click tracking redirects is invalid. This error
     *         appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetTrackingOptionsResponse createConfigurationSetTrackingOptions(
            CreateConfigurationSetTrackingOptionsRequest createConfigurationSetTrackingOptionsRequest)
            throws ConfigurationSetDoesNotExistException, TrackingOptionsAlreadyExistsException, InvalidTrackingOptionsException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetTrackingOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetTrackingOptionsRequest.Builder}
     *        to create a request. Represents a request to create an open and click tracking option object in a
     *        configuration set.
     * @return Result of the CreateConfigurationSetTrackingOptions operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TrackingOptionsAlreadyExistsException
     *         Indicates that the configuration set you specified already contains a TrackingOptions object.
     * @throws InvalidTrackingOptionsException
     *         Indicates that the custom domain to be used for open and click tracking redirects is invalid. This error
     *         appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetTrackingOptionsResponse createConfigurationSetTrackingOptions(
            Consumer<CreateConfigurationSetTrackingOptionsRequest.Builder> createConfigurationSetTrackingOptionsRequest)
            throws ConfigurationSetDoesNotExistException, TrackingOptionsAlreadyExistsException, InvalidTrackingOptionsException,
            AwsServiceException, SdkClientException, SesException {
        return createConfigurationSetTrackingOptions(CreateConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(createConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        Represents a request to create a custom verification email template.
     * @return Result of the CreateCustomVerificationEmailTemplate operation returned by the service.
     * @throws CustomVerificationEmailTemplateAlreadyExistsException
     *         Indicates that a custom verification email template with the name you specified already exists.
     * @throws FromEmailAddressNotVerifiedException
     *         Indicates that the sender address specified for a custom verification email is not verified, and is
     *         therefore not eligible to send the custom verification email.
     * @throws CustomVerificationEmailInvalidContentException
     *         Indicates that custom verification email template provided content is invalid.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(
            CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest)
            throws CustomVerificationEmailTemplateAlreadyExistsException, FromEmailAddressNotVerifiedException,
            CustomVerificationEmailInvalidContentException, LimitExceededException, AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to create a custom verification email template.
     * @return Result of the CreateCustomVerificationEmailTemplate operation returned by the service.
     * @throws CustomVerificationEmailTemplateAlreadyExistsException
     *         Indicates that a custom verification email template with the name you specified already exists.
     * @throws FromEmailAddressNotVerifiedException
     *         Indicates that the sender address specified for a custom verification email is not verified, and is
     *         therefore not eligible to send the custom verification email.
     * @throws CustomVerificationEmailInvalidContentException
     *         Indicates that custom verification email template provided content is invalid.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(
            Consumer<CreateCustomVerificationEmailTemplateRequest.Builder> createCustomVerificationEmailTemplateRequest)
            throws CustomVerificationEmailTemplateAlreadyExistsException, FromEmailAddressNotVerifiedException,
            CustomVerificationEmailInvalidContentException, LimitExceededException, AwsServiceException, SdkClientException,
            SesException {
        return createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(createCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new IP address filter.
     * </p>
     * <p>
     * For information about setting up IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createReceiptFilterRequest
     *        Represents a request to create a new IP address filter. You use IP address filters when you receive email
     *        with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateReceiptFilter operation returned by the service.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReceiptFilterResponse createReceiptFilter(CreateReceiptFilterRequest createReceiptFilterRequest)
            throws LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IP address filter.
     * </p>
     * <p>
     * For information about setting up IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReceiptFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReceiptFilterRequest#builder()}
     * </p>
     *
     * @param createReceiptFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateReceiptFilterRequest.Builder} to create a
     *        request. Represents a request to create a new IP address filter. You use IP address filters when you
     *        receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateReceiptFilter operation returned by the service.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReceiptFilterResponse createReceiptFilter(
            Consumer<CreateReceiptFilterRequest.Builder> createReceiptFilterRequest) throws LimitExceededException,
            AlreadyExistsException, AwsServiceException, SdkClientException, SesException {
        return createReceiptFilter(CreateReceiptFilterRequest.builder().applyMutation(createReceiptFilterRequest).build());
    }

    /**
     * <p>
     * Creates a receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createReceiptRuleRequest
     *        Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateReceiptRule operation returned by the service.
     * @throws InvalidSnsTopicException
     *         Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not publish to the
     *         topic, possibly due to permissions issues. For information about giving permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidS3ConfigurationException
     *         Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or that Amazon SES
     *         could not publish to the bucket, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidLambdaFunctionException
     *         Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could not execute the
     *         provided function, possibly due to permissions issues. For information about giving permissions, see the
     *         <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon
     *         SES Developer Guide</a>.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReceiptRuleResponse createReceiptRule(CreateReceiptRuleRequest createReceiptRuleRequest)
            throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException,
            AlreadyExistsException, RuleDoesNotExistException, RuleSetDoesNotExistException, LimitExceededException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReceiptRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReceiptRuleRequest#builder()}
     * </p>
     *
     * @param createReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateReceiptRuleRequest.Builder} to create a request.
     *        Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateReceiptRule operation returned by the service.
     * @throws InvalidSnsTopicException
     *         Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not publish to the
     *         topic, possibly due to permissions issues. For information about giving permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidS3ConfigurationException
     *         Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or that Amazon SES
     *         could not publish to the bucket, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidLambdaFunctionException
     *         Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could not execute the
     *         provided function, possibly due to permissions issues. For information about giving permissions, see the
     *         <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon
     *         SES Developer Guide</a>.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReceiptRuleResponse createReceiptRule(Consumer<CreateReceiptRuleRequest.Builder> createReceiptRuleRequest)
            throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException,
            AlreadyExistsException, RuleDoesNotExistException, RuleSetDoesNotExistException, LimitExceededException,
            AwsServiceException, SdkClientException, SesException {
        return createReceiptRule(CreateReceiptRuleRequest.builder().applyMutation(createReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Creates an empty receipt rule set.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createReceiptRuleSetRequest
     *        Represents a request to create an empty receipt rule set. You use receipt rule sets to receive email with
     *        Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateReceiptRuleSet operation returned by the service.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReceiptRuleSetResponse createReceiptRuleSet(CreateReceiptRuleSetRequest createReceiptRuleSetRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty receipt rule set.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param createReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to create an empty receipt rule set. You use receipt rule sets to receive
     *        email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateReceiptRuleSet operation returned by the service.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReceiptRuleSetResponse createReceiptRuleSet(
            Consumer<CreateReceiptRuleSetRequest.Builder> createReceiptRuleSetRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, SesException {
        return createReceiptRuleSet(CreateReceiptRuleSetRequest.builder().applyMutation(createReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createTemplateRequest
     *        Represents a request to create an email template. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws InvalidTemplateException
     *         Indicates that the template that you specified could not be rendered. This issue may occur when a
     *         template refers to a partial that does not exist.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest) throws AlreadyExistsException,
            InvalidTemplateException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTemplateRequest#builder()}
     * </p>
     *
     * @param createTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateRequest.Builder} to create a request.
     *        Represents a request to create an email template. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         Indicates that a resource could not be created because of a naming conflict.
     * @throws InvalidTemplateException
     *         Indicates that the template that you specified could not be rendered. This issue may occur when a
     *         template refers to a partial that does not exist.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTemplateResponse createTemplate(Consumer<CreateTemplateRequest.Builder> createTemplateRequest)
            throws AlreadyExistsException, InvalidTemplateException, LimitExceededException, AwsServiceException,
            SdkClientException, SesException {
        return createTemplate(CreateTemplateRequest.builder().applyMutation(createTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about
     * using configuration sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        Represents a request to delete a configuration set. Configuration sets enable you to publish email sending
     *        events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about
     * using configuration sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetRequest.Builder} to create a
     *        request. Represents a request to delete a configuration set. Configuration sets enable you to publish
     *        email sending events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a configuration set event destination. Configuration set event destinations are associated with
     * configuration sets, which enable you to publish email sending events. For information about using configuration
     * sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        Represents a request to delete a configuration set event destination. Configuration set event destinations
     *        are associated with configuration sets, which enable you to publish email sending events. For information
     *        about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteConfigurationSetEventDestination operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws EventDestinationDoesNotExistException
     *         Indicates that the event destination does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest)
            throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException, AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration set event destination. Configuration set event destinations are associated with
     * configuration sets, which enable you to publish email sending events. For information about using configuration
     * sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Represents a request to delete a configuration set event destination. Configuration
     *        set event destinations are associated with configuration sets, which enable you to publish email sending
     *        events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteConfigurationSetEventDestination operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws EventDestinationDoesNotExistException
     *         Indicates that the event destination does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(
            Consumer<DeleteConfigurationSetEventDestinationRequest.Builder> deleteConfigurationSetEventDestinationRequest)
            throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException, AwsServiceException,
            SdkClientException, SesException {
        return deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.builder()
                .applyMutation(deleteConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <note>
     * <p>
     * Deleting this kind of association will result in emails sent using the specified configuration set to capture
     * open and click events using the standard, Amazon SES-operated domains.
     * </p>
     * </note>
     *
     * @param deleteConfigurationSetTrackingOptionsRequest
     *        Represents a request to delete open and click tracking options in a configuration set.
     * @return Result of the DeleteConfigurationSetTrackingOptions operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TrackingOptionsDoesNotExistException
     *         Indicates that the TrackingOptions object you specified does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetTrackingOptionsResponse deleteConfigurationSetTrackingOptions(
            DeleteConfigurationSetTrackingOptionsRequest deleteConfigurationSetTrackingOptionsRequest)
            throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <note>
     * <p>
     * Deleting this kind of association will result in emails sent using the specified configuration set to capture
     * open and click events using the standard, Amazon SES-operated domains.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetTrackingOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetTrackingOptionsRequest.Builder}
     *        to create a request. Represents a request to delete open and click tracking options in a configuration
     *        set.
     * @return Result of the DeleteConfigurationSetTrackingOptions operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TrackingOptionsDoesNotExistException
     *         Indicates that the TrackingOptions object you specified does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetTrackingOptionsResponse deleteConfigurationSetTrackingOptions(
            Consumer<DeleteConfigurationSetTrackingOptionsRequest.Builder> deleteConfigurationSetTrackingOptionsRequest)
            throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, AwsServiceException,
            SdkClientException, SesException {
        return deleteConfigurationSetTrackingOptions(DeleteConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(deleteConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        Represents a request to delete an existing custom verification email template.
     * @return Result of the DeleteCustomVerificationEmailTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(
            DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to delete an existing custom verification email template.
     * @return Result of the DeleteCustomVerificationEmailTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(
            Consumer<DeleteCustomVerificationEmailTemplateRequest.Builder> deleteCustomVerificationEmailTemplateRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(deleteCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified identity (an email address or a domain) from the list of verified identities.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteIdentityRequest
     *        Represents a request to delete one of your Amazon SES identities (an email address or domain).
     * @return Result of the DeleteIdentity operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIdentityResponse deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified identity (an email address or a domain) from the list of verified identities.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIdentityRequest#builder()}
     * </p>
     *
     * @param deleteIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityRequest.Builder} to create a request.
     *        Represents a request to delete one of your Amazon SES identities (an email address or domain).
     * @return Result of the DeleteIdentity operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIdentityResponse deleteIdentity(Consumer<DeleteIdentityRequest.Builder> deleteIdentityRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return deleteIdentity(DeleteIdentityRequest.builder().applyMutation(deleteIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteIdentityPolicyRequest
     *        Represents a request to delete a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon
     *        SES Developer Guide</a>.
     * @return Result of the DeleteIdentityPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIdentityPolicyResponse deleteIdentityPolicy(DeleteIdentityPolicyRequest deleteIdentityPolicyRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param deleteIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to delete a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteIdentityPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIdentityPolicyResponse deleteIdentityPolicy(
            Consumer<DeleteIdentityPolicyRequest.Builder> deleteIdentityPolicyRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return deleteIdentityPolicy(DeleteIdentityPolicyRequest.builder().applyMutation(deleteIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified IP address filter.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteReceiptFilterRequest
     *        Represents a request to delete an IP address filter. You use IP address filters when you receive email
     *        with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteReceiptFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReceiptFilterResponse deleteReceiptFilter(DeleteReceiptFilterRequest deleteReceiptFilterRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IP address filter.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReceiptFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReceiptFilterRequest#builder()}
     * </p>
     *
     * @param deleteReceiptFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReceiptFilterRequest.Builder} to create a
     *        request. Represents a request to delete an IP address filter. You use IP address filters when you receive
     *        email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteReceiptFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReceiptFilterResponse deleteReceiptFilter(
            Consumer<DeleteReceiptFilterRequest.Builder> deleteReceiptFilterRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return deleteReceiptFilter(DeleteReceiptFilterRequest.builder().applyMutation(deleteReceiptFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteReceiptRuleRequest
     *        Represents a request to delete a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteReceiptRule operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReceiptRuleResponse deleteReceiptRule(DeleteReceiptRuleRequest deleteReceiptRuleRequest)
            throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReceiptRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReceiptRuleRequest#builder()}
     * </p>
     *
     * @param deleteReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReceiptRuleRequest.Builder} to create a request.
     *        Represents a request to delete a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteReceiptRule operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReceiptRuleResponse deleteReceiptRule(Consumer<DeleteReceiptRuleRequest.Builder> deleteReceiptRuleRequest)
            throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return deleteReceiptRule(DeleteReceiptRuleRequest.builder().applyMutation(deleteReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified receipt rule set and all of the receipt rules it contains.
     * </p>
     * <note>
     * <p>
     * The currently active rule set cannot be deleted.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteReceiptRuleSetRequest
     *        Represents a request to delete a receipt rule set and all of the receipt rules it contains. You use
     *        receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteReceiptRuleSet operation returned by the service.
     * @throws CannotDeleteException
     *         Indicates that the delete operation could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReceiptRuleSetResponse deleteReceiptRuleSet(DeleteReceiptRuleSetRequest deleteReceiptRuleSetRequest)
            throws CannotDeleteException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified receipt rule set and all of the receipt rules it contains.
     * </p>
     * <note>
     * <p>
     * The currently active rule set cannot be deleted.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param deleteReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to delete a receipt rule set and all of the receipt rules it contains. You
     *        use receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteReceiptRuleSet operation returned by the service.
     * @throws CannotDeleteException
     *         Indicates that the delete operation could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReceiptRuleSetResponse deleteReceiptRuleSet(
            Consumer<DeleteReceiptRuleSetRequest.Builder> deleteReceiptRuleSetRequest) throws CannotDeleteException,
            AwsServiceException, SdkClientException, SesException {
        return deleteReceiptRuleSet(DeleteReceiptRuleSetRequest.builder().applyMutation(deleteReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteTemplateRequest
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTemplateRequest.Builder} to create a request.
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTemplateResponse deleteTemplate(Consumer<DeleteTemplateRequest.Builder> deleteTemplateRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return deleteTemplate(DeleteTemplateRequest.builder().applyMutation(deleteTemplateRequest).build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>DeleteIdentity</code> operation to delete email addresses and domains.
     * </p>
     *
     * @param deleteVerifiedEmailAddressRequest
     *        Represents a request to delete an email address from the list of email addresses you have attempted to
     *        verify under your AWS account.
     * @return Result of the DeleteVerifiedEmailAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteVerifiedEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedEmailAddressResponse deleteVerifiedEmailAddress(
            DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecated. Use the <code>DeleteIdentity</code> operation to delete email addresses and domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedEmailAddressRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVerifiedEmailAddressRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedEmailAddressRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVerifiedEmailAddressRequest.Builder} to create a
     *        request. Represents a request to delete an email address from the list of email addresses you have
     *        attempted to verify under your AWS account.
     * @return Result of the DeleteVerifiedEmailAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DeleteVerifiedEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedEmailAddressResponse deleteVerifiedEmailAddress(
            Consumer<DeleteVerifiedEmailAddressRequest.Builder> deleteVerifiedEmailAddressRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest.builder()
                .applyMutation(deleteVerifiedEmailAddressRequest).build());
    }

    /**
     * <p>
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the DescribeActiveReceiptRuleSet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeActiveReceiptRuleSet
     * @see #describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActiveReceiptRuleSetResponse describeActiveReceiptRuleSet() throws AwsServiceException, SdkClientException,
            SesException {
        return describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest.builder().build());
    }

    /**
     * <p>
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeActiveReceiptRuleSetRequest
     *        Represents a request to return the metadata and receipt rules for the receipt rule set that is currently
     *        active. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeActiveReceiptRuleSet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActiveReceiptRuleSetResponse describeActiveReceiptRuleSet(
            DescribeActiveReceiptRuleSetRequest describeActiveReceiptRuleSetRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActiveReceiptRuleSetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeActiveReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param describeActiveReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActiveReceiptRuleSetRequest.Builder} to create
     *        a request. Represents a request to return the metadata and receipt rules for the receipt rule set that is
     *        currently active. You use receipt rule sets to receive email with Amazon SES. For more information, see
     *        the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon
     *        SES Developer Guide</a>.
     * @return Result of the DescribeActiveReceiptRuleSet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActiveReceiptRuleSetResponse describeActiveReceiptRuleSet(
            Consumer<DescribeActiveReceiptRuleSetRequest.Builder> describeActiveReceiptRuleSetRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest.builder()
                .applyMutation(describeActiveReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Returns the details of the specified configuration set. For information about using configuration sets, see the
     * <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeConfigurationSetRequest
     *        Represents a request to return the details of a configuration set. Configuration sets enable you to
     *        publish email sending events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeConfigurationSet operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigurationSetResponse describeConfigurationSet(
            DescribeConfigurationSetRequest describeConfigurationSetRequest) throws ConfigurationSetDoesNotExistException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the specified configuration set. For information about using configuration sets, see the
     * <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSetRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConfigurationSetRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationSetRequest.Builder} to create a
     *        request. Represents a request to return the details of a configuration set. Configuration sets enable you
     *        to publish email sending events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeConfigurationSet operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigurationSetResponse describeConfigurationSet(
            Consumer<DescribeConfigurationSetRequest.Builder> describeConfigurationSetRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return describeConfigurationSet(DescribeConfigurationSetRequest.builder().applyMutation(describeConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeReceiptRuleRequest
     *        Represents a request to return the details of a receipt rule. You use receipt rules to receive email with
     *        Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeReceiptRule operation returned by the service.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReceiptRuleResponse describeReceiptRule(DescribeReceiptRuleRequest describeReceiptRuleRequest)
            throws RuleDoesNotExistException, RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReceiptRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReceiptRuleRequest#builder()}
     * </p>
     *
     * @param describeReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReceiptRuleRequest.Builder} to create a
     *        request. Represents a request to return the details of a receipt rule. You use receipt rules to receive
     *        email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeReceiptRule operation returned by the service.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReceiptRuleResponse describeReceiptRule(
            Consumer<DescribeReceiptRuleRequest.Builder> describeReceiptRuleRequest) throws RuleDoesNotExistException,
            RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return describeReceiptRule(DescribeReceiptRuleRequest.builder().applyMutation(describeReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeReceiptRuleSetRequest
     *        Represents a request to return the details of a receipt rule set. You use receipt rule sets to receive
     *        email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReceiptRuleSetResponse describeReceiptRuleSet(DescribeReceiptRuleSetRequest describeReceiptRuleSetRequest)
            throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param describeReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to return the details of a receipt rule set. You use receipt rule sets to
     *        receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DescribeReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.DescribeReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReceiptRuleSetResponse describeReceiptRuleSet(
            Consumer<DescribeReceiptRuleSetRequest.Builder> describeReceiptRuleSetRequest) throws RuleSetDoesNotExistException,
            AwsServiceException, SdkClientException, SesException {
        return describeReceiptRuleSet(DescribeReceiptRuleSetRequest.builder().applyMutation(describeReceiptRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns the email sending status of the Amazon SES account for the current region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the GetAccountSendingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetAccountSendingEnabled
     * @see #getAccountSendingEnabled(GetAccountSendingEnabledRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountSendingEnabledResponse getAccountSendingEnabled() throws AwsServiceException, SdkClientException,
            SesException {
        return getAccountSendingEnabled(GetAccountSendingEnabledRequest.builder().build());
    }

    /**
     * <p>
     * Returns the email sending status of the Amazon SES account for the current region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getAccountSendingEnabledRequest
     * @return Result of the GetAccountSendingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountSendingEnabledResponse getAccountSendingEnabled(
            GetAccountSendingEnabledRequest getAccountSendingEnabledRequest) throws AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the email sending status of the Amazon SES account for the current region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSendingEnabledRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccountSendingEnabledRequest#builder()}
     * </p>
     *
     * @param getAccountSendingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSendingEnabledRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountSendingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountSendingEnabledResponse getAccountSendingEnabled(
            Consumer<GetAccountSendingEnabledRequest.Builder> getAccountSendingEnabledRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return getAccountSendingEnabled(GetAccountSendingEnabledRequest.builder().applyMutation(getAccountSendingEnabledRequest)
                .build());
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        Represents a request to retrieve an existing custom verification email template.
     * @return Result of the GetCustomVerificationEmailTemplate operation returned by the service.
     * @throws CustomVerificationEmailTemplateDoesNotExistException
     *         Indicates that a custom verification email template with the name you specified does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(
            GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest)
            throws CustomVerificationEmailTemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomVerificationEmailTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomVerificationEmailTemplateRequest.Builder} to
     *        create a request. Represents a request to retrieve an existing custom verification email template.
     * @return Result of the GetCustomVerificationEmailTemplate operation returned by the service.
     * @throws CustomVerificationEmailTemplateDoesNotExistException
     *         Indicates that a custom verification email template with the name you specified does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(
            Consumer<GetCustomVerificationEmailTemplateRequest.Builder> getCustomVerificationEmailTemplateRequest)
            throws CustomVerificationEmailTemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(getCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also
     * returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified
     * that these tokens have been published.
     * </p>
     * <p>
     * This operation takes a list of identities as input and returns the following information for each:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether Easy DKIM signing is enabled or disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the
     * domain of that address.
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is
     * only returned for domain name identities, not for email addresses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities
     * at a time.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     *
     * @param getIdentityDkimAttributesRequest
     *        Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For domain
     *        identities, this request also returns the DKIM tokens that are required for Easy DKIM signing, and whether
     *        Amazon SES successfully verified that these tokens were published. For more information about Easy DKIM,
     *        see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the GetIdentityDkimAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityDkimAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityDkimAttributesResponse getIdentityDkimAttributes(
            GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) throws AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also
     * returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified
     * that these tokens have been published.
     * </p>
     * <p>
     * This operation takes a list of identities as input and returns the following information for each:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether Easy DKIM signing is enabled or disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the
     * domain of that address.
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is
     * only returned for domain name identities, not for email addresses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities
     * at a time.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityDkimAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link GetIdentityDkimAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityDkimAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityDkimAttributesRequest.Builder} to create a
     *        request. Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For domain
     *        identities, this request also returns the DKIM tokens that are required for Easy DKIM signing, and whether
     *        Amazon SES successfully verified that these tokens were published. For more information about Easy DKIM,
     *        see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the GetIdentityDkimAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityDkimAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityDkimAttributesResponse getIdentityDkimAttributes(
            Consumer<GetIdentityDkimAttributesRequest.Builder> getIdentityDkimAttributesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return getIdentityDkimAttributes(GetIdentityDkimAttributesRequest.builder()
                .applyMutation(getIdentityDkimAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100
     * identities at a time.
     * </p>
     *
     * @param getIdentityMailFromDomainAttributesRequest
     *        Represents a request to return the Amazon SES custom MAIL FROM attributes for a list of identities. For
     *        information about using a custom MAIL FROM domain, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.
     * @return Result of the GetIdentityMailFromDomainAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityMailFromDomainAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityMailFromDomainAttributesResponse getIdentityMailFromDomainAttributes(
            GetIdentityMailFromDomainAttributesRequest getIdentityMailFromDomainAttributesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100
     * identities at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityMailFromDomainAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityMailFromDomainAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityMailFromDomainAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityMailFromDomainAttributesRequest.Builder} to
     *        create a request. Represents a request to return the Amazon SES custom MAIL FROM attributes for a list of
     *        identities. For information about using a custom MAIL FROM domain, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.
     * @return Result of the GetIdentityMailFromDomainAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityMailFromDomainAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityMailFromDomainAttributesResponse getIdentityMailFromDomainAttributes(
            Consumer<GetIdentityMailFromDomainAttributesRequest.Builder> getIdentityMailFromDomainAttributesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return getIdentityMailFromDomainAttributes(GetIdentityMailFromDomainAttributesRequest.builder()
                .applyMutation(getIdentityMailFromDomainAttributesRequest).build());
    }

    /**
     * <p>
     * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity
     * notification attributes.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get notification attributes for up to 100
     * identities at a time.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param getIdentityNotificationAttributesRequest
     *        Represents a request to return the notification attributes for a list of identities you verified with
     *        Amazon SES. For information about Amazon SES notifications, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the GetIdentityNotificationAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityNotificationAttributesResponse getIdentityNotificationAttributes(
            GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity
     * notification attributes.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get notification attributes for up to 100
     * identities at a time.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityNotificationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityNotificationAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityNotificationAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityNotificationAttributesRequest.Builder} to
     *        create a request. Represents a request to return the notification attributes for a list of identities you
     *        verified with Amazon SES. For information about Amazon SES notifications, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the GetIdentityNotificationAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityNotificationAttributesResponse getIdentityNotificationAttributes(
            Consumer<GetIdentityNotificationAttributesRequest.Builder> getIdentityNotificationAttributesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest.builder()
                .applyMutation(getIdentityNotificationAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getIdentityPoliciesRequest
     *        Represents a request to return the requested sending authorization policies for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the GetIdentityPolicies operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIdentityPoliciesResponse getIdentityPolicies(GetIdentityPoliciesRequest getIdentityPoliciesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetIdentityPoliciesRequest#builder()}
     * </p>
     *
     * @param getIdentityPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityPoliciesRequest.Builder} to create a
     *        request. Represents a request to return the requested sending authorization policies for an identity.
     *        Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your
     *        identities. For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the GetIdentityPolicies operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIdentityPoliciesResponse getIdentityPolicies(
            Consumer<GetIdentityPoliciesRequest.Builder> getIdentityPoliciesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return getIdentityPolicies(GetIdentityPoliciesRequest.builder().applyMutation(getIdentityPoliciesRequest).build());
    }

    /**
     * <p>
     * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain
     * identities) the verification token for each identity.
     * </p>
     * <p>
     * The verification status of an email address is "Pending" until the email address owner clicks the link within the
     * verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24
     * hours, the verification status of the email address changes to "Success". If the link is not clicked within 24
     * hours, the verification status changes to "Failed." In that case, if you still want to verify the email address,
     * you must restart the verification process from the beginning.
     * </p>
     * <p>
     * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT
     * record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status
     * changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification
     * status changes to "Failed." In that case, if you still want to verify the domain, you must restart the
     * verification process from the beginning.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get verification attributes for up to 100
     * identities at a time.
     * </p>
     *
     * @param getIdentityVerificationAttributesRequest
     *        Represents a request to return the Amazon SES verification status of a list of identities. For domain
     *        identities, this request also returns the verification token. For information about verifying identities
     *        with Amazon SES, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the GetIdentityVerificationAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityVerificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityVerificationAttributesResponse getIdentityVerificationAttributes(
            GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain
     * identities) the verification token for each identity.
     * </p>
     * <p>
     * The verification status of an email address is "Pending" until the email address owner clicks the link within the
     * verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24
     * hours, the verification status of the email address changes to "Success". If the link is not clicked within 24
     * hours, the verification status changes to "Failed." In that case, if you still want to verify the email address,
     * you must restart the verification process from the beginning.
     * </p>
     * <p>
     * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT
     * record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status
     * changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification
     * status changes to "Failed." In that case, if you still want to verify the domain, you must restart the
     * verification process from the beginning.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get verification attributes for up to 100
     * identities at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityVerificationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityVerificationAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityVerificationAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityVerificationAttributesRequest.Builder} to
     *        create a request. Represents a request to return the Amazon SES verification status of a list of
     *        identities. For domain identities, this request also returns the verification token. For information about
     *        verifying identities with Amazon SES, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the GetIdentityVerificationAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetIdentityVerificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityVerificationAttributesResponse getIdentityVerificationAttributes(
            Consumer<GetIdentityVerificationAttributesRequest.Builder> getIdentityVerificationAttributesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest.builder()
                .applyMutation(getIdentityVerificationAttributesRequest).build());
    }

    /**
     * <p>
     * Provides the sending limits for the Amazon SES account.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the GetSendQuota operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetSendQuota
     * @see #getSendQuota(GetSendQuotaRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSendQuotaResponse getSendQuota() throws AwsServiceException, SdkClientException, SesException {
        return getSendQuota(GetSendQuotaRequest.builder().build());
    }

    /**
     * <p>
     * Provides the sending limits for the Amazon SES account.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getSendQuotaRequest
     * @return Result of the GetSendQuota operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetSendQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSendQuotaResponse getSendQuota(GetSendQuotaRequest getSendQuotaRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the sending limits for the Amazon SES account.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSendQuotaRequest.Builder} avoiding the need to
     * create one manually via {@link GetSendQuotaRequest#builder()}
     * </p>
     *
     * @param getSendQuotaRequest
     *        A {@link Consumer} that will call methods on {@link GetSendQuotaRequest.Builder} to create a request.
     * @return Result of the GetSendQuota operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetSendQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSendQuotaResponse getSendQuota(Consumer<GetSendQuotaRequest.Builder> getSendQuotaRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return getSendQuota(GetSendQuotaRequest.builder().applyMutation(getSendQuotaRequest).build());
    }

    /**
     * <p>
     * Provides sending statistics for the current AWS Region. The result is a list of data points, representing the
     * last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of
     * time.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the GetSendStatistics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetSendStatistics
     * @see #getSendStatistics(GetSendStatisticsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSendStatisticsResponse getSendStatistics() throws AwsServiceException, SdkClientException, SesException {
        return getSendStatistics(GetSendStatisticsRequest.builder().build());
    }

    /**
     * <p>
     * Provides sending statistics for the current AWS Region. The result is a list of data points, representing the
     * last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of
     * time.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getSendStatisticsRequest
     * @return Result of the GetSendStatistics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetSendStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSendStatisticsResponse getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides sending statistics for the current AWS Region. The result is a list of data points, representing the
     * last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of
     * time.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSendStatisticsRequest.Builder} avoiding the need
     * to create one manually via {@link GetSendStatisticsRequest#builder()}
     * </p>
     *
     * @param getSendStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetSendStatisticsRequest.Builder} to create a request.
     * @return Result of the GetSendStatistics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetSendStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSendStatisticsResponse getSendStatistics(Consumer<GetSendStatisticsRequest.Builder> getSendStatisticsRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return getSendStatistics(GetSendStatisticsRequest.builder().applyMutation(getSendStatisticsRequest).build());
    }

    /**
     * <p>
     * Displays the template object (which includes the Subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getTemplateRequest
     * @return Result of the GetTemplate operation returned by the service.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws TemplateDoesNotExistException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the template object (which includes the Subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateRequest.Builder} to create a request.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTemplateResponse getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest)
            throws TemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For
     * information about using configuration sets, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second. This operation will return up to 1,000 configuration
     * sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will
     * also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again,
     * passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional
     * results.
     * </p>
     *
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListConfigurationSets
     * @see #listConfigurationSets(ListConfigurationSetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets() throws AwsServiceException, SdkClientException, SesException {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For
     * information about using configuration sets, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second. This operation will return up to 1,000 configuration
     * sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will
     * also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again,
     * passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional
     * results.
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        Represents a request to list the configuration sets associated with your AWS account. Configuration sets
     *        enable you to publish email sending events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For
     * information about using configuration sets, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second. This operation will return up to 1,000 configuration
     * sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will
     * also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again,
     * passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationSetsRequest.Builder} to create a
     *        request. Represents a request to list the configuration sets associated with your AWS account.
     *        Configuration sets enable you to publish email sending events. For information about using configuration
     *        sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the ListCustomVerificationEmailTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListCustomVerificationEmailTemplates
     * @see #listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates() throws AwsServiceException,
            SdkClientException, SesException {
        return listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email
     *        Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return Result of the ListCustomVerificationEmailTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomVerificationEmailTemplatesRequest.Builder}
     *        to create a request. Represents a request to list the existing custom verification email templates for
     *        your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email
     *        Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return Result of the ListCustomVerificationEmailTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client
     *             .listCustomVerificationEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListCustomVerificationEmailTemplates
     * @see #listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator()
            throws AwsServiceException, SdkClientException, SesException {
        return listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client
     *             .listCustomVerificationEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email
     *        Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client
     *             .listCustomVerificationEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomVerificationEmailTemplatesRequest.Builder}
     *        to create a request. Represents a request to list the existing custom verification email templates for
     *        your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email
     *        Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the ListIdentities operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentities
     * @see #listIdentities(ListIdentitiesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesResponse listIdentities() throws AwsServiceException, SdkClientException, SesException {
        return listIdentities(ListIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listIdentitiesRequest
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return Result of the ListIdentities operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesResponse listIdentities(ListIdentitiesRequest listIdentitiesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIdentitiesRequest#builder()}
     * </p>
     *
     * @param listIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentitiesRequest.Builder} to create a request.
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return Result of the ListIdentities operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesResponse listIdentities(Consumer<ListIdentitiesRequest.Builder> listIdentitiesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return listIdentities(ListIdentitiesRequest.builder().applyMutation(listIdentitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.ses.model.ListIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentities
     * @see #listIdentitiesPaginator(ListIdentitiesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesIterable listIdentitiesPaginator() throws AwsServiceException, SdkClientException, SesException {
        return listIdentitiesPaginator(ListIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.ses.model.ListIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)} operation.</b>
     * </p>
     *
     * @param listIdentitiesRequest
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesIterable listIdentitiesPaginator(ListIdentitiesRequest listIdentitiesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.ses.model.ListIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable responses = client.listIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIdentitiesRequest#builder()}
     * </p>
     *
     * @param listIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentitiesRequest.Builder} to create a request.
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesIterable listIdentitiesPaginator(Consumer<ListIdentitiesRequest.Builder> listIdentitiesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return listIdentitiesPaginator(ListIdentitiesRequest.builder().applyMutation(listIdentitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list of sending authorization policies that are attached to the given identity (an email address or a
     * domain). This API returns only a list. If you want the actual policy content, you can use
     * <code>GetIdentityPolicies</code>.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listIdentityPoliciesRequest
     *        Represents a request to return a list of sending authorization policies that are attached to an identity.
     *        Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your
     *        identities. For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListIdentityPolicies operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentityPoliciesResponse listIdentityPolicies(ListIdentityPoliciesRequest listIdentityPoliciesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sending authorization policies that are attached to the given identity (an email address or a
     * domain). This API returns only a list. If you want the actual policy content, you can use
     * <code>GetIdentityPolicies</code>.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityPoliciesRequest#builder()}
     * </p>
     *
     * @param listIdentityPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityPoliciesRequest.Builder} to create a
     *        request. Represents a request to return a list of sending authorization policies that are attached to an
     *        identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to
     *        use your identities. For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListIdentityPolicies operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentityPoliciesResponse listIdentityPolicies(
            Consumer<ListIdentityPoliciesRequest.Builder> listIdentityPoliciesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return listIdentityPolicies(ListIdentityPoliciesRequest.builder().applyMutation(listIdentityPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the IP address filters associated with your AWS account in the current AWS Region.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the ListReceiptFilters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListReceiptFilters
     * @see #listReceiptFilters(ListReceiptFiltersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReceiptFiltersResponse listReceiptFilters() throws AwsServiceException, SdkClientException, SesException {
        return listReceiptFilters(ListReceiptFiltersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IP address filters associated with your AWS account in the current AWS Region.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listReceiptFiltersRequest
     *        Represents a request to list the IP address filters that exist under your AWS account. You use IP address
     *        filters when you receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListReceiptFilters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListReceiptFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReceiptFiltersResponse listReceiptFilters(ListReceiptFiltersRequest listReceiptFiltersRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IP address filters associated with your AWS account in the current AWS Region.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceiptFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceiptFiltersRequest#builder()}
     * </p>
     *
     * @param listReceiptFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListReceiptFiltersRequest.Builder} to create a
     *        request. Represents a request to list the IP address filters that exist under your AWS account. You use IP
     *        address filters when you receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListReceiptFilters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListReceiptFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReceiptFiltersResponse listReceiptFilters(Consumer<ListReceiptFiltersRequest.Builder> listReceiptFiltersRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return listReceiptFilters(ListReceiptFiltersRequest.builder().applyMutation(listReceiptFiltersRequest).build());
    }

    /**
     * <p>
     * Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional
     * receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next
     * call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the ListReceiptRuleSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListReceiptRuleSets
     * @see #listReceiptRuleSets(ListReceiptRuleSetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReceiptRuleSetsResponse listReceiptRuleSets() throws AwsServiceException, SdkClientException, SesException {
        return listReceiptRuleSets(ListReceiptRuleSetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional
     * receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next
     * call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listReceiptRuleSetsRequest
     *        Represents a request to list the receipt rule sets that exist under your AWS account. You use receipt rule
     *        sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListReceiptRuleSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListReceiptRuleSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReceiptRuleSetsResponse listReceiptRuleSets(ListReceiptRuleSetsRequest listReceiptRuleSetsRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional
     * receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next
     * call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceiptRuleSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceiptRuleSetsRequest#builder()}
     * </p>
     *
     * @param listReceiptRuleSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListReceiptRuleSetsRequest.Builder} to create a
     *        request. Represents a request to list the receipt rule sets that exist under your AWS account. You use
     *        receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListReceiptRuleSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListReceiptRuleSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReceiptRuleSetsResponse listReceiptRuleSets(
            Consumer<ListReceiptRuleSetsRequest.Builder> listReceiptRuleSetsRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return listReceiptRuleSets(ListReceiptRuleSetsRequest.builder().applyMutation(listReceiptRuleSetsRequest).build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current AWS Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the ListTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListTemplates
     * @see #listTemplates(ListTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesResponse listTemplates() throws AwsServiceException, SdkClientException, SesException {
        return listTemplates(ListTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current AWS Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listTemplatesRequest
     * @return Result of the ListTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current AWS Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return Result of the ListTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesResponse listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with
     * your account.
     * </p>
     *
     * @return Result of the ListVerifiedEmailAddresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListVerifiedEmailAddresses
     * @see #listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVerifiedEmailAddressesResponse listVerifiedEmailAddresses() throws AwsServiceException, SdkClientException,
            SesException {
        return listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest.builder().build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with
     * your account.
     * </p>
     *
     * @param listVerifiedEmailAddressesRequest
     * @return Result of the ListVerifiedEmailAddresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListVerifiedEmailAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVerifiedEmailAddressesResponse listVerifiedEmailAddresses(
            ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVerifiedEmailAddressesRequest.Builder} avoiding
     * the need to create one manually via {@link ListVerifiedEmailAddressesRequest#builder()}
     * </p>
     *
     * @param listVerifiedEmailAddressesRequest
     *        A {@link Consumer} that will call methods on {@link ListVerifiedEmailAddressesRequest.Builder} to create a
     *        request.
     * @return Result of the ListVerifiedEmailAddresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ListVerifiedEmailAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVerifiedEmailAddressesResponse listVerifiedEmailAddresses(
            Consumer<ListVerifiedEmailAddressesRequest.Builder> listVerifiedEmailAddressesRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest.builder()
                .applyMutation(listVerifiedEmailAddressesRequest).build());
    }

    /**
     * <p>
     * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putIdentityPolicyRequest
     *        Represents a request to add or update a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the PutIdentityPolicy operation returned by the service.
     * @throws InvalidPolicyException
     *         Indicates that the provided policy is invalid. Check the error stack for more information about what
     *         caused the error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.PutIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutIdentityPolicyResponse putIdentityPolicy(PutIdentityPolicyRequest putIdentityPolicyRequest)
            throws InvalidPolicyException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIdentityPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param putIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutIdentityPolicyRequest.Builder} to create a request.
     *        Represents a request to add or update a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the PutIdentityPolicy operation returned by the service.
     * @throws InvalidPolicyException
     *         Indicates that the provided policy is invalid. Check the error stack for more information about what
     *         caused the error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.PutIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutIdentityPolicyResponse putIdentityPolicy(Consumer<PutIdentityPolicyRequest.Builder> putIdentityPolicyRequest)
            throws InvalidPolicyException, AwsServiceException, SdkClientException, SesException {
        return putIdentityPolicy(PutIdentityPolicyRequest.builder().applyMutation(putIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Reorders the receipt rules within a receipt rule set.
     * </p>
     * <note>
     * <p>
     * All of the rules in the rule set must be represented in this request. That is, this API will return an error if
     * the reorder request doesn't explicitly position all of the rules.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param reorderReceiptRuleSetRequest
     *        Represents a request to reorder the receipt rules within a receipt rule set. You use receipt rule sets to
     *        receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ReorderReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ReorderReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default ReorderReceiptRuleSetResponse reorderReceiptRuleSet(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest)
            throws RuleSetDoesNotExistException, RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reorders the receipt rules within a receipt rule set.
     * </p>
     * <note>
     * <p>
     * All of the rules in the rule set must be represented in this request. That is, this API will return an error if
     * the reorder request doesn't explicitly position all of the rules.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReorderReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link ReorderReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param reorderReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link ReorderReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to reorder the receipt rules within a receipt rule set. You use receipt rule
     *        sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ReorderReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.ReorderReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default ReorderReceiptRuleSetResponse reorderReceiptRuleSet(
            Consumer<ReorderReceiptRuleSetRequest.Builder> reorderReceiptRuleSetRequest) throws RuleSetDoesNotExistException,
            RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return reorderReceiptRuleSet(ReorderReceiptRuleSetRequest.builder().applyMutation(reorderReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use
     * this API on an email up to 24 hours after you receive it.
     * </p>
     * <note>
     * <p>
     * You cannot use this API to send generic bounces for mail that was not received by Amazon SES.
     * </p>
     * </note>
     * <p>
     * For information about receiving email through Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendBounceRequest
     *        Represents a request to send a bounce message to the sender of an email you received through Amazon SES.
     * @return Result of the SendBounce operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendBounce
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce" target="_top">AWS API
     *      Documentation</a>
     */
    default SendBounceResponse sendBounce(SendBounceRequest sendBounceRequest) throws MessageRejectedException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use
     * this API on an email up to 24 hours after you receive it.
     * </p>
     * <note>
     * <p>
     * You cannot use this API to send generic bounces for mail that was not received by Amazon SES.
     * </p>
     * </note>
     * <p>
     * For information about receiving email through Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBounceRequest.Builder} avoiding the need to
     * create one manually via {@link SendBounceRequest#builder()}
     * </p>
     *
     * @param sendBounceRequest
     *        A {@link Consumer} that will call methods on {@link SendBounceRequest.Builder} to create a request.
     *        Represents a request to send a bounce message to the sender of an email you received through Amazon SES.
     * @return Result of the SendBounce operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendBounce
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce" target="_top">AWS API
     *      Documentation</a>
     */
    default SendBounceResponse sendBounce(Consumer<SendBounceRequest.Builder> sendBounceRequest) throws MessageRejectedException,
            AwsServiceException, SdkClientException, SesException {
        return sendBounce(SendBounceRequest.builder().applyMutation(sendBounceRequest).build());
    }

    /**
     * <p>
     * Composes an email message to multiple destinations. The message body is created using an email template.
     * </p>
     * <p>
     * In order to send email using the <code>SendBulkTemplatedEmail</code> operation, your call to the API must meet
     * the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendBulkTemplatedEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of destinations you can contact in a single call to the API may be limited by your account's maximum
     * sending rate.
     * </p>
     * </li>
     * </ul>
     *
     * @param sendBulkTemplatedEmailRequest
     *        Represents a request to send a templated email to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendBulkTemplatedEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendBulkTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBulkTemplatedEmail" target="_top">AWS
     *      API Documentation</a>
     */
    default SendBulkTemplatedEmailResponse sendBulkTemplatedEmail(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest)
            throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException,
            TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message to multiple destinations. The message body is created using an email template.
     * </p>
     * <p>
     * In order to send email using the <code>SendBulkTemplatedEmail</code> operation, your call to the API must meet
     * the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendBulkTemplatedEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of destinations you can contact in a single call to the API may be limited by your account's maximum
     * sending rate.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBulkTemplatedEmailRequest.Builder} avoiding the
     * need to create one manually via {@link SendBulkTemplatedEmailRequest#builder()}
     * </p>
     *
     * @param sendBulkTemplatedEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendBulkTemplatedEmailRequest.Builder} to create a
     *        request. Represents a request to send a templated email to multiple destinations using Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendBulkTemplatedEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendBulkTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBulkTemplatedEmail" target="_top">AWS
     *      API Documentation</a>
     */
    default SendBulkTemplatedEmailResponse sendBulkTemplatedEmail(
            Consumer<SendBulkTemplatedEmailRequest.Builder> sendBulkTemplatedEmailRequest) throws MessageRejectedException,
            MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, TemplateDoesNotExistException,
            ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException,
            SesException {
        return sendBulkTemplatedEmail(SendBulkTemplatedEmailRequest.builder().applyMutation(sendBulkTemplatedEmailRequest)
                .build());
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and
     * attempts to verify it. As a result of executing this operation, a customized verification email is sent to the
     * specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        Represents a request to send a custom verification email to a specified recipient.
     * @return Result of the SendCustomVerificationEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws CustomVerificationEmailTemplateDoesNotExistException
     *         Indicates that a custom verification email template with the name you specified does not exist.
     * @throws FromEmailAddressNotVerifiedException
     *         Indicates that the sender address specified for a custom verification email is not verified, and is
     *         therefore not eligible to send the custom verification email.
     * @throws ProductionAccessNotGrantedException
     *         Indicates that the account has not been granted production access.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendCustomVerificationEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCustomVerificationEmailResponse sendCustomVerificationEmail(
            SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) throws MessageRejectedException,
            ConfigurationSetDoesNotExistException, CustomVerificationEmailTemplateDoesNotExistException,
            FromEmailAddressNotVerifiedException, ProductionAccessNotGrantedException, AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and
     * attempts to verify it. As a result of executing this operation, a customized verification email is sent to the
     * specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCustomVerificationEmailRequest.Builder}
     * avoiding the need to create one manually via {@link SendCustomVerificationEmailRequest#builder()}
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendCustomVerificationEmailRequest.Builder} to create
     *        a request. Represents a request to send a custom verification email to a specified recipient.
     * @return Result of the SendCustomVerificationEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws CustomVerificationEmailTemplateDoesNotExistException
     *         Indicates that a custom verification email template with the name you specified does not exist.
     * @throws FromEmailAddressNotVerifiedException
     *         Indicates that the sender address specified for a custom verification email is not verified, and is
     *         therefore not eligible to send the custom verification email.
     * @throws ProductionAccessNotGrantedException
     *         Indicates that the account has not been granted production access.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendCustomVerificationEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCustomVerificationEmailResponse sendCustomVerificationEmail(
            Consumer<SendCustomVerificationEmailRequest.Builder> sendCustomVerificationEmailRequest)
            throws MessageRejectedException, ConfigurationSetDoesNotExistException,
            CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException,
            ProductionAccessNotGrantedException, AwsServiceException, SdkClientException, SesException {
        return sendCustomVerificationEmail(SendCustomVerificationEmailRequest.builder()
                .applyMutation(sendCustomVerificationEmailRequest).build());
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending. In order to send email using the
     * <code>SendEmail</code> operation, your message must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain. If you attempt to send email using a
     * non-verified address or domain, the operation will result in an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must include at least one recipient email address. The recipient address can be a To: address, a CC:
     * address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format
     * <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message
     * contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </important>
     *
     * @param sendEmailRequest
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the SendEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws MessageRejectedException,
            MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException,
            AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending. In order to send email using the
     * <code>SendEmail</code> operation, your message must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain. If you attempt to send email using a
     * non-verified address or domain, the operation will result in an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must include at least one recipient email address. The recipient address can be a To: address, a CC:
     * address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format
     * <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message
     * contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendEmailRequest#builder()}
     * </p>
     *
     * @param sendEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendEmailRequest.Builder} to create a request.
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the SendEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendEmailResponse sendEmail(Consumer<SendEmailRequest.Builder> sendEmailRequest) throws MessageRejectedException,
            MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException,
            AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        return sendEmail(SendEmailRequest.builder().applyMutation(sendEmailRequest).build());
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending.
     * </p>
     * <p>
     * This operation is more flexible than the <code>SendEmail</code> API operation. When you use the
     * <code>SendRawEmail</code> operation, you can specify the headers of the message as well as its content. This
     * flexibility is useful, for example, when you want to send a multipart MIME email (such a message that contains
     * both a text and an HTML version). You can also use this operation to send messages that include attachments.
     * </p>
     * <p>
     * The <code>SendRawEmail</code> operation has the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only send email from <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">verified email
     * addresses or domains</a>. If you try to send email from an address that isn't verified, the operation results in
     * an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html">Amazon SES
     * sandbox</a>, you can only send email to other verified addresses in your account, or to addresses that are
     * associated with the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html">Amazon
     * SES mailbox simulator</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size, including attachments, is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message has to include at least one recipient address. A recipient address includes any address on the To:,
     * CC:, or BCC: lines.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a
     * valid format (that is, it's not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), Amazon SES
     * rejects the entire message, even if the other addresses are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a
     * single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less
     * than 50 recipients, and send separate messages to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES
     * has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't
     * preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding">MIME
     * Encoding</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Additionally, keep the following considerations in mind when using the <code>SendRawEmail</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Although you can customize the message headers when using the <code>SendRawEmail</code> operation, Amazon SES
     * will automatically apply its own <code>Message-ID</code> and <code>Date</code> headers; if you passed these
     * headers when creating the message, they will be overwritten by the values that Amazon SES provides.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are using sending authorization to send on behalf of another user, <code>SendRawEmail</code> enables you
     * to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two
     * ways: you can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>, and/or
     * <code>ReturnPathArn</code> to the API, or you can include the following X-headers in the header of your raw
     * email:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>X-SES-SOURCE-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-FROM-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-RETURN-PATH-ARN</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Do not include these X-headers in the DKIM signature; Amazon SES will remove them before sending the email.
     * </p>
     * </important>
     * <p>
     * For most common sending authorization scenarios, we recommend that you specify the <code>SourceIdentityArn</code>
     * parameter and not the <code>FromIdentityArn</code> or <code>ReturnPathIdentityArn</code> parameters. If you only
     * specify the <code>SourceIdentityArn</code> parameter, Amazon SES will set the From and Return Path addresses to
     * the identity specified in <code>SourceIdentityArn</code>. For more information about sending authorization, see
     * the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Using Sending
     * Authorization with Amazon SES</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param sendRawEmailRequest
     *        Represents a request to send a single raw email using Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the SendRawEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendRawEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendRawEmailResponse sendRawEmail(SendRawEmailRequest sendRawEmailRequest) throws MessageRejectedException,
            MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException,
            AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending.
     * </p>
     * <p>
     * This operation is more flexible than the <code>SendEmail</code> API operation. When you use the
     * <code>SendRawEmail</code> operation, you can specify the headers of the message as well as its content. This
     * flexibility is useful, for example, when you want to send a multipart MIME email (such a message that contains
     * both a text and an HTML version). You can also use this operation to send messages that include attachments.
     * </p>
     * <p>
     * The <code>SendRawEmail</code> operation has the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only send email from <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">verified email
     * addresses or domains</a>. If you try to send email from an address that isn't verified, the operation results in
     * an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html">Amazon SES
     * sandbox</a>, you can only send email to other verified addresses in your account, or to addresses that are
     * associated with the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html">Amazon
     * SES mailbox simulator</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size, including attachments, is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message has to include at least one recipient address. A recipient address includes any address on the To:,
     * CC:, or BCC: lines.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a
     * valid format (that is, it's not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), Amazon SES
     * rejects the entire message, even if the other addresses are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a
     * single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less
     * than 50 recipients, and send separate messages to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES
     * has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't
     * preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding">MIME
     * Encoding</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Additionally, keep the following considerations in mind when using the <code>SendRawEmail</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Although you can customize the message headers when using the <code>SendRawEmail</code> operation, Amazon SES
     * will automatically apply its own <code>Message-ID</code> and <code>Date</code> headers; if you passed these
     * headers when creating the message, they will be overwritten by the values that Amazon SES provides.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are using sending authorization to send on behalf of another user, <code>SendRawEmail</code> enables you
     * to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two
     * ways: you can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>, and/or
     * <code>ReturnPathArn</code> to the API, or you can include the following X-headers in the header of your raw
     * email:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>X-SES-SOURCE-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-FROM-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-RETURN-PATH-ARN</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Do not include these X-headers in the DKIM signature; Amazon SES will remove them before sending the email.
     * </p>
     * </important>
     * <p>
     * For most common sending authorization scenarios, we recommend that you specify the <code>SourceIdentityArn</code>
     * parameter and not the <code>FromIdentityArn</code> or <code>ReturnPathIdentityArn</code> parameters. If you only
     * specify the <code>SourceIdentityArn</code> parameter, Amazon SES will set the From and Return Path addresses to
     * the identity specified in <code>SourceIdentityArn</code>. For more information about sending authorization, see
     * the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Using Sending
     * Authorization with Amazon SES</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendRawEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendRawEmailRequest#builder()}
     * </p>
     *
     * @param sendRawEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendRawEmailRequest.Builder} to create a request.
     *        Represents a request to send a single raw email using Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the SendRawEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendRawEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendRawEmailResponse sendRawEmail(Consumer<SendRawEmailRequest.Builder> sendRawEmailRequest)
            throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException,
            ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException,
            SesException {
        return sendRawEmail(SendRawEmailRequest.builder().applyMutation(sendRawEmailRequest).build());
    }

    /**
     * <p>
     * Composes an email message using an email template and immediately queues it for sending.
     * </p>
     * <p>
     * In order to send email using the <code>SendTemplatedEmail</code> operation, your call to the API must meet the
     * following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to the <code>SendTemplatedEmail</code> operation may only include one <code>Destination</code> parameter. A
     * destination is a set of recipients who will receive the same version of the email. The <code>Destination</code>
     * parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If your call to the <code>SendTemplatedEmail</code> operation includes all of the required parameters, Amazon SES
     * accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains
     * errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't
     * return a message stating that it was unable to send the email.
     * </p>
     * <p>
     * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering
     * Failure events occur. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Sending Personalized
     * Email Using the Amazon SES API</a> in the <i>Amazon Simple Email Service Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param sendTemplatedEmailRequest
     *        Represents a request to send a templated email using Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendTemplatedEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendTemplatedEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTemplatedEmailResponse sendTemplatedEmail(SendTemplatedEmailRequest sendTemplatedEmailRequest)
            throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException,
            TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message using an email template and immediately queues it for sending.
     * </p>
     * <p>
     * In order to send email using the <code>SendTemplatedEmail</code> operation, your call to the API must meet the
     * following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to the <code>SendTemplatedEmail</code> operation may only include one <code>Destination</code> parameter. A
     * destination is a set of recipients who will receive the same version of the email. The <code>Destination</code>
     * parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If your call to the <code>SendTemplatedEmail</code> operation includes all of the required parameters, Amazon SES
     * accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains
     * errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't
     * return a message stating that it was unable to send the email.
     * </p>
     * <p>
     * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering
     * Failure events occur. For more information, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Sending Personalized
     * Email Using the Amazon SES API</a> in the <i>Amazon Simple Email Service Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTemplatedEmailRequest.Builder} avoiding the
     * need to create one manually via {@link SendTemplatedEmailRequest#builder()}
     * </p>
     *
     * @param sendTemplatedEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendTemplatedEmailRequest.Builder} to create a
     *        request. Represents a request to send a templated email using Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendTemplatedEmail operation returned by the service.
     * @throws MessageRejectedException
     *         Indicates that the action failed, and the message could not be sent. Check the error stack for more
     *         information about what caused the error.
     * @throws MailFromDomainNotVerifiedException
     *         Indicates that the message could not be sent because Amazon SES could not read the MX record required to
     *         use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings
     *         for an identity, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws ConfigurationSetSendingPausedException
     *         Indicates that email sending is disabled for the configuration set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.
     * @throws AccountSendingPausedException
     *         Indicates that email sending is disabled for your entire Amazon SES account.
     *         </p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SendTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendTemplatedEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTemplatedEmailResponse sendTemplatedEmail(Consumer<SendTemplatedEmailRequest.Builder> sendTemplatedEmailRequest)
            throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException,
            TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException,
            AwsServiceException, SdkClientException, SesException {
        return sendTemplatedEmail(SendTemplatedEmailRequest.builder().applyMutation(sendTemplatedEmailRequest).build());
    }

    /**
     * <p>
     * Sets the specified receipt rule set as the active receipt rule set.
     * </p>
     * <note>
     * <p>
     * To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to
     * null.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return Result of the SetActiveReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetActiveReceiptRuleSet
     * @see #setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default SetActiveReceiptRuleSetResponse setActiveReceiptRuleSet() throws RuleSetDoesNotExistException, AwsServiceException,
            SdkClientException, SesException {
        return setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest.builder().build());
    }

    /**
     * <p>
     * Sets the specified receipt rule set as the active receipt rule set.
     * </p>
     * <note>
     * <p>
     * To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to
     * null.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param setActiveReceiptRuleSetRequest
     *        Represents a request to set a receipt rule set as the active receipt rule set. You use receipt rule sets
     *        to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetActiveReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default SetActiveReceiptRuleSetResponse setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest setActiveReceiptRuleSetRequest)
            throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified receipt rule set as the active receipt rule set.
     * </p>
     * <note>
     * <p>
     * To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to
     * null.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetActiveReceiptRuleSetRequest.Builder} avoiding
     * the need to create one manually via {@link SetActiveReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param setActiveReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link SetActiveReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to set a receipt rule set as the active receipt rule set. You use receipt
     *        rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetActiveReceiptRuleSet operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default SetActiveReceiptRuleSetResponse setActiveReceiptRuleSet(
            Consumer<SetActiveReceiptRuleSetRequest.Builder> setActiveReceiptRuleSetRequest) throws RuleSetDoesNotExistException,
            AwsServiceException, SdkClientException, SesException {
        return setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest.builder().applyMutation(setActiveReceiptRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Enables or disables Easy DKIM signing of email sent from an identity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If Easy DKIM signing is enabled for a domain name identity (such as <code>example.com</code>), then Amazon SES
     * will DKIM-sign all email sent by addresses under that domain name (for example, <code>user@example.com</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * If Easy DKIM signing is enabled for an email address, then Amazon SES will DKIM-sign all email sent by that email
     * address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For email addresses (for example, <code>user@example.com</code>), you can only enable Easy DKIM signing if the
     * corresponding domain (in this case, <code>example.com</code>) has been set up for Easy DKIM using the AWS Console
     * or the <code>VerifyDomainDkim</code> operation.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about Easy DKIM signing, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityDkimEnabledRequest
     *        Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * @return Result of the SetIdentityDkimEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityDkimEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default SetIdentityDkimEnabledResponse setIdentityDkimEnabled(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables Easy DKIM signing of email sent from an identity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If Easy DKIM signing is enabled for a domain name identity (such as <code>example.com</code>), then Amazon SES
     * will DKIM-sign all email sent by addresses under that domain name (for example, <code>user@example.com</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * If Easy DKIM signing is enabled for an email address, then Amazon SES will DKIM-sign all email sent by that email
     * address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For email addresses (for example, <code>user@example.com</code>), you can only enable Easy DKIM signing if the
     * corresponding domain (in this case, <code>example.com</code>) has been set up for Easy DKIM using the AWS Console
     * or the <code>VerifyDomainDkim</code> operation.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about Easy DKIM signing, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityDkimEnabledRequest.Builder} avoiding the
     * need to create one manually via {@link SetIdentityDkimEnabledRequest#builder()}
     * </p>
     *
     * @param setIdentityDkimEnabledRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityDkimEnabledRequest.Builder} to create a
     *        request. Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * @return Result of the SetIdentityDkimEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityDkimEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default SetIdentityDkimEnabledResponse setIdentityDkimEnabled(
            Consumer<SetIdentityDkimEnabledRequest.Builder> setIdentityDkimEnabledRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return setIdentityDkimEnabled(SetIdentityDkimEnabledRequest.builder().applyMutation(setIdentityDkimEnabledRequest)
                .build());
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and
     * complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification
     * Service (Amazon SNS) topics are specified for both bounces and complaints.
     * </p>
     * <note>
     * <p>
     * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through
     * Amazon SNS.
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityFeedbackForwardingEnabledRequest
     *        Represents a request to enable or disable whether Amazon SES forwards you bounce and complaint
     *        notifications through email. For information about email feedback forwarding, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetIdentityFeedbackForwardingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityFeedbackForwardingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityFeedbackForwardingEnabledResponse setIdentityFeedbackForwardingEnabled(
            SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and
     * complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification
     * Service (Amazon SNS) topics are specified for both bounces and complaints.
     * </p>
     * <note>
     * <p>
     * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through
     * Amazon SNS.
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SetIdentityFeedbackForwardingEnabledRequest.Builder} avoiding the need to create one manually via
     * {@link SetIdentityFeedbackForwardingEnabledRequest#builder()}
     * </p>
     *
     * @param setIdentityFeedbackForwardingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityFeedbackForwardingEnabledRequest.Builder}
     *        to create a request. Represents a request to enable or disable whether Amazon SES forwards you bounce and
     *        complaint notifications through email. For information about email feedback forwarding, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetIdentityFeedbackForwardingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityFeedbackForwardingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityFeedbackForwardingEnabledResponse setIdentityFeedbackForwardingEnabled(
            Consumer<SetIdentityFeedbackForwardingEnabledRequest.Builder> setIdentityFeedbackForwardingEnabledRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest.builder()
                .applyMutation(setIdentityFeedbackForwardingEnabledRequest).build());
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in
     * the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityHeadersInNotificationsEnabledRequest
     *        Represents a request to set whether Amazon SES includes the original email headers in the Amazon SNS
     *        notifications of a specified type. For information about notifications, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetIdentityHeadersInNotificationsEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityHeadersInNotificationsEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityHeadersInNotificationsEnabledResponse setIdentityHeadersInNotificationsEnabled(
            SetIdentityHeadersInNotificationsEnabledRequest setIdentityHeadersInNotificationsEnabledRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in
     * the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SetIdentityHeadersInNotificationsEnabledRequest.Builder} avoiding the need to create one manually via
     * {@link SetIdentityHeadersInNotificationsEnabledRequest#builder()}
     * </p>
     *
     * @param setIdentityHeadersInNotificationsEnabledRequest
     *        A {@link Consumer} that will call methods on
     *        {@link SetIdentityHeadersInNotificationsEnabledRequest.Builder} to create a request. Represents a request
     *        to set whether Amazon SES includes the original email headers in the Amazon SNS notifications of a
     *        specified type. For information about notifications, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetIdentityHeadersInNotificationsEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityHeadersInNotificationsEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityHeadersInNotificationsEnabledResponse setIdentityHeadersInNotificationsEnabled(
            Consumer<SetIdentityHeadersInNotificationsEnabledRequest.Builder> setIdentityHeadersInNotificationsEnabledRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return setIdentityHeadersInNotificationsEnabled(SetIdentityHeadersInNotificationsEnabledRequest.builder()
                .applyMutation(setIdentityHeadersInNotificationsEnabledRequest).build());
    }

    /**
     * <p>
     * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     * </p>
     * <important>
     * <p>
     * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS
     * settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an
     * SPF record. For more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer Guide</a>.
     * </p>
     * </important>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param setIdentityMailFromDomainRequest
     *        Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a verified
     *        identity. For information about using a custom MAIL FROM domain, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.
     * @return Result of the SetIdentityMailFromDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityMailFromDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityMailFromDomainResponse setIdentityMailFromDomain(
            SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) throws AwsServiceException, SdkClientException,
            SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     * </p>
     * <important>
     * <p>
     * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS
     * settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an
     * SPF record. For more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer Guide</a>.
     * </p>
     * </important>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityMailFromDomainRequest.Builder} avoiding
     * the need to create one manually via {@link SetIdentityMailFromDomainRequest#builder()}
     * </p>
     *
     * @param setIdentityMailFromDomainRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityMailFromDomainRequest.Builder} to create a
     *        request. Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a
     *        verified identity. For information about using a custom MAIL FROM domain, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.
     * @return Result of the SetIdentityMailFromDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityMailFromDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityMailFromDomainResponse setIdentityMailFromDomain(
            Consumer<SetIdentityMailFromDomainRequest.Builder> setIdentityMailFromDomainRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return setIdentityMailFromDomain(SetIdentityMailFromDomainRequest.builder()
                .applyMutation(setIdentityMailFromDomainRequest).build());
    }

    /**
     * <p>
     * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use
     * this operation, you specify a verified identity, such as an email address or domain. When you send an email that
     * uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can
     * send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that
     * you specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about feedback notification, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityNotificationTopicRequest
     *        Represents a request to specify the Amazon SNS topic to which Amazon SES will publish bounce, complaint,
     *        or delivery notifications for emails sent with that identity as the Source. For information about Amazon
     *        SES notifications, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetIdentityNotificationTopic operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityNotificationTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityNotificationTopicResponse setIdentityNotificationTopic(
            SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use
     * this operation, you specify a verified identity, such as an email address or domain. When you send an email that
     * uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can
     * send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that
     * you specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about feedback notification, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityNotificationTopicRequest.Builder}
     * avoiding the need to create one manually via {@link SetIdentityNotificationTopicRequest#builder()}
     * </p>
     *
     * @param setIdentityNotificationTopicRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityNotificationTopicRequest.Builder} to create
     *        a request. Represents a request to specify the Amazon SNS topic to which Amazon SES will publish bounce,
     *        complaint, or delivery notifications for emails sent with that identity as the Source. For information
     *        about Amazon SES notifications, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetIdentityNotificationTopic operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetIdentityNotificationTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIdentityNotificationTopicResponse setIdentityNotificationTopic(
            Consumer<SetIdentityNotificationTopicRequest.Builder> setIdentityNotificationTopicRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return setIdentityNotificationTopic(SetIdentityNotificationTopicRequest.builder()
                .applyMutation(setIdentityNotificationTopicRequest).build());
    }

    /**
     * <p>
     * Sets the position of the specified receipt rule in the receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param setReceiptRulePositionRequest
     *        Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt rule
     *        sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetReceiptRulePosition operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetReceiptRulePosition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default SetReceiptRulePositionResponse setReceiptRulePosition(SetReceiptRulePositionRequest setReceiptRulePositionRequest)
            throws RuleSetDoesNotExistException, RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the position of the specified receipt rule in the receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetReceiptRulePositionRequest.Builder} avoiding the
     * need to create one manually via {@link SetReceiptRulePositionRequest#builder()}
     * </p>
     *
     * @param setReceiptRulePositionRequest
     *        A {@link Consumer} that will call methods on {@link SetReceiptRulePositionRequest.Builder} to create a
     *        request. Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt
     *        rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SetReceiptRulePosition operation returned by the service.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.SetReceiptRulePosition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default SetReceiptRulePositionResponse setReceiptRulePosition(
            Consumer<SetReceiptRulePositionRequest.Builder> setReceiptRulePositionRequest) throws RuleSetDoesNotExistException,
            RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return setReceiptRulePosition(SetReceiptRulePositionRequest.builder().applyMutation(setReceiptRulePositionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param testRenderTemplateRequest
     * @return Result of the TestRenderTemplate operation returned by the service.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws InvalidRenderingParameterException
     *         Indicates that one or more of the replacement values you provided is invalid. This error may occur when
     *         the TemplateData object contains invalid JSON.
     * @throws MissingRenderingAttributeException
     *         Indicates that one or more of the replacement values for the specified template was not specified. Ensure
     *         that the TemplateData object contains references to all of the replacement tags in the specified
     *         template.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.TestRenderTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default TestRenderTemplateResponse testRenderTemplate(TestRenderTemplateRequest testRenderTemplateRequest)
            throws TemplateDoesNotExistException, InvalidRenderingParameterException, MissingRenderingAttributeException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestRenderTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link TestRenderTemplateRequest#builder()}
     * </p>
     *
     * @param testRenderTemplateRequest
     *        A {@link Consumer} that will call methods on {@link TestRenderTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the TestRenderTemplate operation returned by the service.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws InvalidRenderingParameterException
     *         Indicates that one or more of the replacement values you provided is invalid. This error may occur when
     *         the TemplateData object contains invalid JSON.
     * @throws MissingRenderingAttributeException
     *         Indicates that one or more of the replacement values for the specified template was not specified. Ensure
     *         that the TemplateData object contains references to all of the replacement tags in the specified
     *         template.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.TestRenderTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default TestRenderTemplateResponse testRenderTemplate(Consumer<TestRenderTemplateRequest.Builder> testRenderTemplateRequest)
            throws TemplateDoesNotExistException, InvalidRenderingParameterException, MissingRenderingAttributeException,
            AwsServiceException, SdkClientException, SesException {
        return testRenderTemplate(TestRenderTemplateRequest.builder().applyMutation(testRenderTemplateRequest).build());
    }

    /**
     * <p>
     * Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use
     * this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon
     * SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain
     * thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateAccountSendingEnabledRequest
     *        Represents a request to enable or disable the email sending capabilities for your entire Amazon SES
     *        account.
     * @return Result of the UpdateAccountSendingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateAccountSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountSendingEnabledResponse updateAccountSendingEnabled(
            UpdateAccountSendingEnabledRequest updateAccountSendingEnabledRequest) throws AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use
     * this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon
     * SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain
     * thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSendingEnabledRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAccountSendingEnabledRequest#builder()}
     * </p>
     *
     * @param updateAccountSendingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountSendingEnabledRequest.Builder} to create
     *        a request. Represents a request to enable or disable the email sending capabilities for your entire Amazon
     *        SES account.
     * @return Result of the UpdateAccountSendingEnabled operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateAccountSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountSendingEnabledResponse updateAccountSendingEnabled(
            Consumer<UpdateAccountSendingEnabledRequest.Builder> updateAccountSendingEnabledRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return updateAccountSendingEnabled(UpdateAccountSendingEnabledRequest.builder()
                .applyMutation(updateAccountSendingEnabledRequest).build());
    }

    /**
     * <p>
     * Updates the event destination of a configuration set. Event destinations are associated with configuration sets,
     * which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple
     * Notification Service (Amazon SNS). For information about using configuration sets, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        Represents a request to update the event destination of a configuration set. Configuration sets enable you
     *        to publish email sending events. For information about using configuration sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the UpdateConfigurationSetEventDestination operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws EventDestinationDoesNotExistException
     *         Indicates that the event destination does not exist.
     * @throws InvalidCloudWatchDestinationException
     *         Indicates that the Amazon CloudWatch destination is invalid. See the error message for details.
     * @throws InvalidFirehoseDestinationException
     *         Indicates that the Amazon Kinesis Firehose destination is invalid. See the error message for details.
     * @throws InvalidSnsDestinationException
     *         Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error
     *         message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest)
            throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException,
            InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the event destination of a configuration set. Event destinations are associated with configuration sets,
     * which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple
     * Notification Service (Amazon SNS). For information about using configuration sets, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Represents a request to update the event destination of a configuration set.
     *        Configuration sets enable you to publish email sending events. For information about using configuration
     *        sets, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the UpdateConfigurationSetEventDestination operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws EventDestinationDoesNotExistException
     *         Indicates that the event destination does not exist.
     * @throws InvalidCloudWatchDestinationException
     *         Indicates that the Amazon CloudWatch destination is invalid. See the error message for details.
     * @throws InvalidFirehoseDestinationException
     *         Indicates that the Amazon Kinesis Firehose destination is invalid. See the error message for details.
     * @throws InvalidSnsDestinationException
     *         Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error
     *         message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(
            Consumer<UpdateConfigurationSetEventDestinationRequest.Builder> updateConfigurationSetEventDestinationRequest)
            throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException,
            InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException,
            AwsServiceException, SdkClientException, SesException {
        return updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(updateConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a
     * given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon
     * CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateConfigurationSetReputationMetricsEnabledRequest
     *        Represents a request to modify the reputation metric publishing settings for a configuration set.
     * @return Result of the UpdateConfigurationSetReputationMetricsEnabled operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetReputationMetricsEnabled
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetReputationMetricsEnabledResponse updateConfigurationSetReputationMetricsEnabled(
            UpdateConfigurationSetReputationMetricsEnabledRequest updateConfigurationSetReputationMetricsEnabledRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a
     * given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon
     * CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetReputationMetricsEnabledRequest.Builder} avoiding the need to create one manually
     * via {@link UpdateConfigurationSetReputationMetricsEnabledRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetReputationMetricsEnabledRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateConfigurationSetReputationMetricsEnabledRequest.Builder} to create a request. Represents a
     *        request to modify the reputation metric publishing settings for a configuration set.
     * @return Result of the UpdateConfigurationSetReputationMetricsEnabled operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetReputationMetricsEnabled
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetReputationMetricsEnabledResponse updateConfigurationSetReputationMetricsEnabled(
            Consumer<UpdateConfigurationSetReputationMetricsEnabledRequest.Builder> updateConfigurationSetReputationMetricsEnabledRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return updateConfigurationSetReputationMetricsEnabled(UpdateConfigurationSetReputationMetricsEnabledRequest.builder()
                .applyMutation(updateConfigurationSetReputationMetricsEnabledRequest).build());
    }

    /**
     * <p>
     * Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You
     * can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a
     * configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate)
     * exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateConfigurationSetSendingEnabledRequest
     *        Represents a request to enable or disable the email sending capabilities for a specific configuration set.
     * @return Result of the UpdateConfigurationSetSendingEnabled operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetSendingEnabledResponse updateConfigurationSetSendingEnabled(
            UpdateConfigurationSetSendingEnabledRequest updateConfigurationSetSendingEnabledRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You
     * can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a
     * configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate)
     * exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetSendingEnabledRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetSendingEnabledRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetSendingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetSendingEnabledRequest.Builder}
     *        to create a request. Represents a request to enable or disable the email sending capabilities for a
     *        specific configuration set.
     * @return Result of the UpdateConfigurationSetSendingEnabled operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetSendingEnabledResponse updateConfigurationSetSendingEnabled(
            Consumer<UpdateConfigurationSetSendingEnabledRequest.Builder> updateConfigurationSetSendingEnabledRequest)
            throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        return updateConfigurationSetSendingEnabled(UpdateConfigurationSetSendingEnabledRequest.builder()
                .applyMutation(updateConfigurationSetSendingEnabledRequest).build());
    }

    /**
     * <p>
     * Modifies an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     *
     * @param updateConfigurationSetTrackingOptionsRequest
     *        Represents a request to update the tracking options for a configuration set.
     * @return Result of the UpdateConfigurationSetTrackingOptions operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TrackingOptionsDoesNotExistException
     *         Indicates that the TrackingOptions object you specified does not exist.
     * @throws InvalidTrackingOptionsException
     *         Indicates that the custom domain to be used for open and click tracking redirects is invalid. This error
     *         appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetTrackingOptionsResponse updateConfigurationSetTrackingOptions(
            UpdateConfigurationSetTrackingOptionsRequest updateConfigurationSetTrackingOptionsRequest)
            throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, InvalidTrackingOptionsException,
            AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetTrackingOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetTrackingOptionsRequest.Builder}
     *        to create a request. Represents a request to update the tracking options for a configuration set.
     * @return Result of the UpdateConfigurationSetTrackingOptions operation returned by the service.
     * @throws ConfigurationSetDoesNotExistException
     *         Indicates that the configuration set does not exist.
     * @throws TrackingOptionsDoesNotExistException
     *         Indicates that the TrackingOptions object you specified does not exist.
     * @throws InvalidTrackingOptionsException
     *         Indicates that the custom domain to be used for open and click tracking redirects is invalid. This error
     *         appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetTrackingOptionsResponse updateConfigurationSetTrackingOptions(
            Consumer<UpdateConfigurationSetTrackingOptionsRequest.Builder> updateConfigurationSetTrackingOptionsRequest)
            throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, InvalidTrackingOptionsException,
            AwsServiceException, SdkClientException, SesException {
        return updateConfigurationSetTrackingOptions(UpdateConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(updateConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        Represents a request to update an existing custom verification email template.
     * @return Result of the UpdateCustomVerificationEmailTemplate operation returned by the service.
     * @throws CustomVerificationEmailTemplateDoesNotExistException
     *         Indicates that a custom verification email template with the name you specified does not exist.
     * @throws FromEmailAddressNotVerifiedException
     *         Indicates that the sender address specified for a custom verification email is not verified, and is
     *         therefore not eligible to send the custom verification email.
     * @throws CustomVerificationEmailInvalidContentException
     *         Indicates that custom verification email template provided content is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(
            UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest)
            throws CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException,
            CustomVerificationEmailInvalidContentException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to update an existing custom verification email template.
     * @return Result of the UpdateCustomVerificationEmailTemplate operation returned by the service.
     * @throws CustomVerificationEmailTemplateDoesNotExistException
     *         Indicates that a custom verification email template with the name you specified does not exist.
     * @throws FromEmailAddressNotVerifiedException
     *         Indicates that the sender address specified for a custom verification email is not verified, and is
     *         therefore not eligible to send the custom verification email.
     * @throws CustomVerificationEmailInvalidContentException
     *         Indicates that custom verification email template provided content is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(
            Consumer<UpdateCustomVerificationEmailTemplateRequest.Builder> updateCustomVerificationEmailTemplateRequest)
            throws CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException,
            CustomVerificationEmailInvalidContentException, AwsServiceException, SdkClientException, SesException {
        return updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(updateCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Updates a receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateReceiptRuleRequest
     *        Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the UpdateReceiptRule operation returned by the service.
     * @throws InvalidSnsTopicException
     *         Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not publish to the
     *         topic, possibly due to permissions issues. For information about giving permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidS3ConfigurationException
     *         Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or that Amazon SES
     *         could not publish to the bucket, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidLambdaFunctionException
     *         Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could not execute the
     *         provided function, possibly due to permissions issues. For information about giving permissions, see the
     *         <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon
     *         SES Developer Guide</a>.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateReceiptRuleResponse updateReceiptRule(UpdateReceiptRuleRequest updateReceiptRuleRequest)
            throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException,
            RuleSetDoesNotExistException, RuleDoesNotExistException, LimitExceededException, AwsServiceException,
            SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReceiptRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReceiptRuleRequest#builder()}
     * </p>
     *
     * @param updateReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReceiptRuleRequest.Builder} to create a request.
     *        Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the UpdateReceiptRule operation returned by the service.
     * @throws InvalidSnsTopicException
     *         Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not publish to the
     *         topic, possibly due to permissions issues. For information about giving permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidS3ConfigurationException
     *         Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or that Amazon SES
     *         could not publish to the bucket, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.
     * @throws InvalidLambdaFunctionException
     *         Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could not execute the
     *         provided function, possibly due to permissions issues. For information about giving permissions, see the
     *         <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon
     *         SES Developer Guide</a>.
     * @throws RuleSetDoesNotExistException
     *         Indicates that the provided receipt rule set does not exist.
     * @throws RuleDoesNotExistException
     *         Indicates that the provided receipt rule does not exist.
     * @throws LimitExceededException
     *         Indicates that a resource could not be created because of service limits. For a list of Amazon SES
     *         limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES
     *         Developer Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateReceiptRuleResponse updateReceiptRule(Consumer<UpdateReceiptRuleRequest.Builder> updateReceiptRuleRequest)
            throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException,
            RuleSetDoesNotExistException, RuleDoesNotExistException, LimitExceededException, AwsServiceException,
            SdkClientException, SesException {
        return updateReceiptRule(UpdateReceiptRuleRequest.builder().applyMutation(updateReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateTemplateRequest
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws InvalidTemplateException
     *         Indicates that the template that you specified could not be rendered. This issue may occur when a
     *         template refers to a partial that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest)
            throws TemplateDoesNotExistException, InvalidTemplateException, AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTemplateRequest#builder()}
     * </p>
     *
     * @param updateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateRequest.Builder} to create a request.
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws TemplateDoesNotExistException
     *         Indicates that the Template object you specified does not exist in your Amazon SES account.
     * @throws InvalidTemplateException
     *         Indicates that the template that you specified could not be rendered. This issue may occur when a
     *         template refers to a partial that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTemplateResponse updateTemplate(Consumer<UpdateTemplateRequest.Builder> updateTemplateRequest)
            throws TemplateDoesNotExistException, InvalidTemplateException, AwsServiceException, SdkClientException, SesException {
        return updateTemplate(UpdateTemplateRequest.builder().applyMutation(updateTemplateRequest).build());
    }

    /**
     * <p>
     * Returns a set of DKIM tokens for a domain. DKIM <i>tokens</i> are character strings that represent your domain's
     * identity. Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by
     * Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection
     * process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign email
     * originating from that domain.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * To enable or disable Easy DKIM signing for a domain, use the <code>SetIdentityDkimEnabled</code> operation.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     *
     * @param verifyDomainDkimRequest
     *        Represents a request to generate the CNAME records needed to set up Easy DKIM with Amazon SES. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * @return Result of the VerifyDomainDkim operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyDomainDkim
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyDomainDkimResponse verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of DKIM tokens for a domain. DKIM <i>tokens</i> are character strings that represent your domain's
     * identity. Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by
     * Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection
     * process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign email
     * originating from that domain.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * To enable or disable Easy DKIM signing for a domain, use the <code>SetIdentityDkimEnabled</code> operation.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyDomainDkimRequest.Builder} avoiding the need
     * to create one manually via {@link VerifyDomainDkimRequest#builder()}
     * </p>
     *
     * @param verifyDomainDkimRequest
     *        A {@link Consumer} that will call methods on {@link VerifyDomainDkimRequest.Builder} to create a request.
     *        Represents a request to generate the CNAME records needed to set up Easy DKIM with Amazon SES. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * @return Result of the VerifyDomainDkim operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyDomainDkim
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyDomainDkimResponse verifyDomainDkim(Consumer<VerifyDomainDkimRequest.Builder> verifyDomainDkimRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return verifyDomainDkim(VerifyDomainDkimRequest.builder().applyMutation(verifyDomainDkimRequest).build());
    }

    /**
     * <p>
     * Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to
     * verify it. For more information about verifying domains, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param verifyDomainIdentityRequest
     *        Represents a request to begin Amazon SES domain verification and to generate the TXT records that you must
     *        publish to the DNS server of your domain to complete the verification. For information about domain
     *        verification, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the VerifyDomainIdentity operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyDomainIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyDomainIdentityResponse verifyDomainIdentity(VerifyDomainIdentityRequest verifyDomainIdentityRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to
     * verify it. For more information about verifying domains, see <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyDomainIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyDomainIdentityRequest#builder()}
     * </p>
     *
     * @param verifyDomainIdentityRequest
     *        A {@link Consumer} that will call methods on {@link VerifyDomainIdentityRequest.Builder} to create a
     *        request. Represents a request to begin Amazon SES domain verification and to generate the TXT records that
     *        you must publish to the DNS server of your domain to complete the verification. For information about
     *        domain verification, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES Developer
     *        Guide</a>.
     * @return Result of the VerifyDomainIdentity operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyDomainIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyDomainIdentityResponse verifyDomainIdentity(
            Consumer<VerifyDomainIdentityRequest.Builder> verifyDomainIdentityRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return verifyDomainIdentity(VerifyDomainIdentityRequest.builder().applyMutation(verifyDomainIdentityRequest).build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>VerifyEmailIdentity</code> operation to verify a new email address.
     * </p>
     *
     * @param verifyEmailAddressRequest
     *        Represents a request to begin email address verification with Amazon SES. For information about email
     *        address verification, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the VerifyEmailAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyEmailAddressResponse verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecated. Use the <code>VerifyEmailIdentity</code> operation to verify a new email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyEmailAddressRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyEmailAddressRequest#builder()}
     * </p>
     *
     * @param verifyEmailAddressRequest
     *        A {@link Consumer} that will call methods on {@link VerifyEmailAddressRequest.Builder} to create a
     *        request. Represents a request to begin email address verification with Amazon SES. For information about
     *        email address verification, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the VerifyEmailAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyEmailAddressResponse verifyEmailAddress(Consumer<VerifyEmailAddressRequest.Builder> verifyEmailAddressRequest)
            throws AwsServiceException, SdkClientException, SesException {
        return verifyEmailAddress(VerifyEmailAddressRequest.builder().applyMutation(verifyEmailAddressRequest).build());
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS region and
     * attempts to verify it. As a result of executing this operation, a verification email is sent to the specified
     * address.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param verifyEmailIdentityRequest
     *        Represents a request to begin email address verification with Amazon SES. For information about email
     *        address verification, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the VerifyEmailIdentity operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyEmailIdentityResponse verifyEmailIdentity(VerifyEmailIdentityRequest verifyEmailIdentityRequest)
            throws AwsServiceException, SdkClientException, SesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS region and
     * attempts to verify it. As a result of executing this operation, a verification email is sent to the specified
     * address.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyEmailIdentityRequest#builder()}
     * </p>
     *
     * @param verifyEmailIdentityRequest
     *        A {@link Consumer} that will call methods on {@link VerifyEmailIdentityRequest.Builder} to create a
     *        request. Represents a request to begin email address verification with Amazon SES. For information about
     *        email address verification, see the <a
     *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the VerifyEmailIdentity operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesClient.VerifyEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default VerifyEmailIdentityResponse verifyEmailIdentity(
            Consumer<VerifyEmailIdentityRequest.Builder> verifyEmailIdentityRequest) throws AwsServiceException,
            SdkClientException, SesException {
        return verifyEmailIdentity(VerifyEmailIdentityRequest.builder().applyMutation(verifyEmailIdentityRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("email");
    }
}
