/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliveryOptions implements SdkPojo, Serializable, ToCopyableBuilder<DeliveryOptions.Builder, DeliveryOptions> {
    private static final SdkField<String> TLS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeliveryOptions::tlsPolicyAsString)).setter(setter(Builder::tlsPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tlsPolicy;

    private DeliveryOptions(BuilderImpl builder) {
        this.tlsPolicy = builder.tlsPolicy;
    }

    /**
     * <p>
     * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If
     * the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the
     * value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsPolicy} will
     * return {@link TlsPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tlsPolicyAsString}.
     * </p>
     * 
     * @return Specifies whether messages that use the configuration set are required to use Transport Layer Security
     *         (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
     *         established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
     *         connection can't be established.
     * @see TlsPolicy
     */
    public TlsPolicy tlsPolicy() {
        return TlsPolicy.fromValue(tlsPolicy);
    }

    /**
     * <p>
     * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If
     * the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the
     * value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsPolicy} will
     * return {@link TlsPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tlsPolicyAsString}.
     * </p>
     * 
     * @return Specifies whether messages that use the configuration set are required to use Transport Layer Security
     *         (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
     *         established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
     *         connection can't be established.
     * @see TlsPolicy
     */
    public String tlsPolicyAsString() {
        return tlsPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tlsPolicyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryOptions)) {
            return false;
        }
        DeliveryOptions other = (DeliveryOptions) obj;
        return Objects.equals(tlsPolicyAsString(), other.tlsPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeliveryOptions").add("TlsPolicy", tlsPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TlsPolicy":
            return Optional.ofNullable(clazz.cast(tlsPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryOptions, T> g) {
        return obj -> g.apply((DeliveryOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliveryOptions> {
        /**
         * <p>
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If
         * the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be
         * established.
         * </p>
         * 
         * @param tlsPolicy
         *        Specifies whether messages that use the configuration set are required to use Transport Layer Security
         *        (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
         *        established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
         *        connection can't be established.
         * @see TlsPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlsPolicy
         */
        Builder tlsPolicy(String tlsPolicy);

        /**
         * <p>
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If
         * the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be
         * established.
         * </p>
         * 
         * @param tlsPolicy
         *        Specifies whether messages that use the configuration set are required to use Transport Layer Security
         *        (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
         *        established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
         *        connection can't be established.
         * @see TlsPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlsPolicy
         */
        Builder tlsPolicy(TlsPolicy tlsPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String tlsPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryOptions model) {
            tlsPolicy(model.tlsPolicy);
        }

        public final String getTlsPolicyAsString() {
            return tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy == null ? null : tlsPolicy.toString());
            return this;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        @Override
        public DeliveryOptions build() {
            return new DeliveryOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
