/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRenderTemplateResponse extends SesResponse implements
        ToCopyableBuilder<TestRenderTemplateResponse.Builder, TestRenderTemplateResponse> {
    private static final SdkField<String> RENDERED_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestRenderTemplateResponse::renderedTemplate)).setter(setter(Builder::renderedTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenderedTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDERED_TEMPLATE_FIELD));

    private final String renderedTemplate;

    private TestRenderTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.renderedTemplate = builder.renderedTemplate;
    }

    /**
     * <p>
     * The complete MIME message rendered by applying the data in the TemplateData parameter to the template specified
     * in the TemplateName parameter.
     * </p>
     * 
     * @return The complete MIME message rendered by applying the data in the TemplateData parameter to the template
     *         specified in the TemplateName parameter.
     */
    public String renderedTemplate() {
        return renderedTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(renderedTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRenderTemplateResponse)) {
            return false;
        }
        TestRenderTemplateResponse other = (TestRenderTemplateResponse) obj;
        return Objects.equals(renderedTemplate(), other.renderedTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestRenderTemplateResponse").add("RenderedTemplate", renderedTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RenderedTemplate":
            return Optional.ofNullable(clazz.cast(renderedTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRenderTemplateResponse, T> g) {
        return obj -> g.apply((TestRenderTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestRenderTemplateResponse> {
        /**
         * <p>
         * The complete MIME message rendered by applying the data in the TemplateData parameter to the template
         * specified in the TemplateName parameter.
         * </p>
         * 
         * @param renderedTemplate
         *        The complete MIME message rendered by applying the data in the TemplateData parameter to the template
         *        specified in the TemplateName parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderedTemplate(String renderedTemplate);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private String renderedTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRenderTemplateResponse model) {
            super(model);
            renderedTemplate(model.renderedTemplate);
        }

        public final String getRenderedTemplate() {
            return renderedTemplate;
        }

        @Override
        public final Builder renderedTemplate(String renderedTemplate) {
            this.renderedTemplate = renderedTemplate;
            return this;
        }

        public final void setRenderedTemplate(String renderedTemplate) {
            this.renderedTemplate = renderedTemplate;
        }

        @Override
        public TestRenderTemplateResponse build() {
            return new TestRenderTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
