/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon SES verification status of a list of identities. For domain identities, this response also contains the
 * verification token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityVerificationAttributesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityVerificationAttributesResponse.Builder, GetIdentityVerificationAttributesResponse> {
    private static final SdkField<Map<String, IdentityVerificationAttributes>> VERIFICATION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, IdentityVerificationAttributes>> builder(MarshallingType.MAP)
            .getter(getter(GetIdentityVerificationAttributesResponse::verificationAttributes))
            .setter(setter(Builder::verificationAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IdentityVerificationAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityVerificationAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VERIFICATION_ATTRIBUTES_FIELD));

    private final Map<String, IdentityVerificationAttributes> verificationAttributes;

    private GetIdentityVerificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.verificationAttributes = builder.verificationAttributes;
    }

    /**
     * Returns true if the VerificationAttributes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVerificationAttributes() {
        return verificationAttributes != null && !(verificationAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of Identities to IdentityVerificationAttributes objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVerificationAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of Identities to IdentityVerificationAttributes objects.
     */
    public Map<String, IdentityVerificationAttributes> verificationAttributes() {
        return verificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verificationAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesResponse)) {
            return false;
        }
        GetIdentityVerificationAttributesResponse other = (GetIdentityVerificationAttributesResponse) obj;
        return Objects.equals(verificationAttributes(), other.verificationAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetIdentityVerificationAttributesResponse")
                .add("VerificationAttributes", verificationAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerificationAttributes":
            return Optional.ofNullable(clazz.cast(verificationAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityVerificationAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityVerificationAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
        /**
         * <p>
         * A map of Identities to IdentityVerificationAttributes objects.
         * </p>
         * 
         * @param verificationAttributes
         *        A map of Identities to IdentityVerificationAttributes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, IdentityVerificationAttributes> verificationAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesResponse model) {
            super(model);
            verificationAttributes(model.verificationAttributes);
        }

        public final Map<String, IdentityVerificationAttributes.Builder> getVerificationAttributes() {
            return verificationAttributes != null ? CollectionUtils.mapValues(verificationAttributes,
                    IdentityVerificationAttributes::toBuilder) : null;
        }

        @Override
        public final Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copy(verificationAttributes);
            return this;
        }

        public final void setVerificationAttributes(Map<String, IdentityVerificationAttributes.BuilderImpl> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copyFromBuilder(verificationAttributes);
        }

        @Override
        public GetIdentityVerificationAttributesResponse build() {
            return new GetIdentityVerificationAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
