/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response received when attempting to send the custom verification email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendCustomVerificationEmailResponse extends SesResponse implements
        ToCopyableBuilder<SendCustomVerificationEmailResponse.Builder, SendCustomVerificationEmailResponse> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendCustomVerificationEmailResponse::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD));

    private final String messageId;

    private SendCustomVerificationEmailResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
    }

    /**
     * <p>
     * The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.
     * </p>
     * 
     * @return The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.
     */
    public String messageId() {
        return messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCustomVerificationEmailResponse)) {
            return false;
        }
        SendCustomVerificationEmailResponse other = (SendCustomVerificationEmailResponse) obj;
        return Objects.equals(messageId(), other.messageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendCustomVerificationEmailResponse").add("MessageId", messageId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendCustomVerificationEmailResponse, T> g) {
        return obj -> g.apply((SendCustomVerificationEmailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendCustomVerificationEmailResponse> {
        /**
         * <p>
         * The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.
         * </p>
         * 
         * @param messageId
         *        The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCustomVerificationEmailResponse model) {
            super(model);
            messageId(model.messageId);
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public SendCustomVerificationEmailResponse build() {
            return new SendCustomVerificationEmailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
