/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityMailFromDomainAttributesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityMailFromDomainAttributesResponse.Builder, GetIdentityMailFromDomainAttributesResponse> {
    private static final SdkField<Map<String, IdentityMailFromDomainAttributes>> MAIL_FROM_DOMAIN_ATTRIBUTES_FIELD = SdkField
            .<Map<String, IdentityMailFromDomainAttributes>> builder(MarshallingType.MAP)
            .memberName("MailFromDomainAttributes")
            .getter(getter(GetIdentityMailFromDomainAttributesResponse::mailFromDomainAttributes))
            .setter(setter(Builder::mailFromDomainAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomainAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IdentityMailFromDomainAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityMailFromDomainAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAIL_FROM_DOMAIN_ATTRIBUTES_FIELD));

    private final Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

    private GetIdentityMailFromDomainAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.mailFromDomainAttributes = builder.mailFromDomainAttributes;
    }

    /**
     * Returns true if the MailFromDomainAttributes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMailFromDomainAttributes() {
        return mailFromDomainAttributes != null && !(mailFromDomainAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of identities to custom MAIL FROM attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMailFromDomainAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of identities to custom MAIL FROM attributes.
     */
    public Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes() {
        return mailFromDomainAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomainAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityMailFromDomainAttributesResponse)) {
            return false;
        }
        GetIdentityMailFromDomainAttributesResponse other = (GetIdentityMailFromDomainAttributesResponse) obj;
        return Objects.equals(mailFromDomainAttributes(), other.mailFromDomainAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetIdentityMailFromDomainAttributesResponse")
                .add("MailFromDomainAttributes", mailFromDomainAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailFromDomainAttributes":
            return Optional.ofNullable(clazz.cast(mailFromDomainAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityMailFromDomainAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityMailFromDomainAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityMailFromDomainAttributesResponse> {
        /**
         * <p>
         * A map of identities to custom MAIL FROM attributes.
         * </p>
         * 
         * @param mailFromDomainAttributes
         *        A map of identities to custom MAIL FROM attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityMailFromDomainAttributesResponse model) {
            super(model);
            mailFromDomainAttributes(model.mailFromDomainAttributes);
        }

        public final Map<String, IdentityMailFromDomainAttributes.Builder> getMailFromDomainAttributes() {
            return mailFromDomainAttributes != null ? CollectionUtils.mapValues(mailFromDomainAttributes,
                    IdentityMailFromDomainAttributes::toBuilder) : null;
        }

        @Override
        public final Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copy(mailFromDomainAttributes);
            return this;
        }

        public final void setMailFromDomainAttributes(
                Map<String, IdentityMailFromDomainAttributes.BuilderImpl> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copyFromBuilder(mailFromDomainAttributes);
        }

        @Override
        public GetIdentityMailFromDomainAttributesResponse build() {
            return new GetIdentityMailFromDomainAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
