/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of IP address filters that exist under your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReceiptFiltersResponse extends SesResponse implements
        ToCopyableBuilder<ListReceiptFiltersResponse.Builder, ListReceiptFiltersResponse> {
    private static final SdkField<List<ReceiptFilter>> FILTERS_FIELD = SdkField
            .<List<ReceiptFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListReceiptFiltersResponse::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReceiptFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReceiptFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD));

    private final List<ReceiptFilter> filters;

    private ListReceiptFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether to
     * allow or block mail from it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of IP address filter data structures, which each consist of a name, an IP address range, and
     *         whether to allow or block mail from it.
     */
    public List<ReceiptFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptFiltersResponse)) {
            return false;
        }
        ListReceiptFiltersResponse other = (ListReceiptFiltersResponse) obj;
        return Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListReceiptFiltersResponse").add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReceiptFiltersResponse, T> g) {
        return obj -> g.apply((ListReceiptFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReceiptFiltersResponse> {
        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * 
         * @param filters
         *        A list of IP address filter data structures, which each consist of a name, an IP address range, and
         *        whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ReceiptFilter> filters);

        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * 
         * @param filters
         *        A list of IP address filter data structures, which each consist of a name, an IP address range, and
         *        whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ReceiptFilter... filters);

        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReceiptFilter>.Builder} avoiding the need
         * to create one manually via {@link List<ReceiptFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReceiptFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ReceiptFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ReceiptFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ReceiptFilter>)
         */
        Builder filters(Consumer<ReceiptFilter.Builder>... filters);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<ReceiptFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptFiltersResponse model) {
            super(model);
            filters(model.filters);
        }

        public final Collection<ReceiptFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(ReceiptFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ReceiptFilter> filters) {
            this.filters = ReceiptFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ReceiptFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ReceiptFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ReceiptFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ReceiptFilter.BuilderImpl> filters) {
            this.filters = ReceiptFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public ListReceiptFiltersResponse build() {
            return new ListReceiptFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
