/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkmailAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkmailAction> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(WorkmailAction.getter(WorkmailAction::topicArn)).setter(WorkmailAction.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationArn").getter(WorkmailAction.getter(WorkmailAction::organizationArn)).setter(WorkmailAction.setter(Builder::organizationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, ORGANIZATION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicArn;
    private final String organizationArn;

    private WorkmailAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.organizationArn = builder.organizationArn;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String organizationArn() {
        return this.organizationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkmailAction)) {
            return false;
        }
        WorkmailAction other = (WorkmailAction)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.organizationArn(), other.organizationArn());
    }

    public String toString() {
        return ToString.builder((String)"WorkmailAction").add("TopicArn", (Object)this.topicArn()).add("OrganizationArn", (Object)this.organizationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "OrganizationArn": {
                return Optional.ofNullable(clazz.cast(this.organizationArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkmailAction, T> g) {
        return obj -> g.apply((WorkmailAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String organizationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkmailAction model) {
            this.topicArn(model.topicArn);
            this.organizationArn(model.organizationArn);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getOrganizationArn() {
            return this.organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        public WorkmailAction build() {
            return new WorkmailAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkmailAction> {
        public Builder topicArn(String var1);

        public Builder organizationArn(String var1);
    }
}

