/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action that Amazon SES can take when it receives an email on behalf of one or more email addresses or domains that
 * you own. An instance of this data type can represent only one action.
 * </p>
 * <p>
 * For information about setting up receipt rules, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceiptAction implements SdkPojo, Serializable, ToCopyableBuilder<ReceiptAction.Builder, ReceiptAction> {
    private static final SdkField<S3Action> S3_ACTION_FIELD = SdkField.<S3Action> builder(MarshallingType.SDK_POJO)
            .memberName("S3Action").getter(getter(ReceiptAction::s3Action)).setter(setter(Builder::s3Action))
            .constructor(S3Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Action").build()).build();

    private static final SdkField<BounceAction> BOUNCE_ACTION_FIELD = SdkField.<BounceAction> builder(MarshallingType.SDK_POJO)
            .memberName("BounceAction").getter(getter(ReceiptAction::bounceAction)).setter(setter(Builder::bounceAction))
            .constructor(BounceAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceAction").build()).build();

    private static final SdkField<WorkmailAction> WORKMAIL_ACTION_FIELD = SdkField
            .<WorkmailAction> builder(MarshallingType.SDK_POJO).memberName("WorkmailAction")
            .getter(getter(ReceiptAction::workmailAction)).setter(setter(Builder::workmailAction))
            .constructor(WorkmailAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkmailAction").build()).build();

    private static final SdkField<LambdaAction> LAMBDA_ACTION_FIELD = SdkField.<LambdaAction> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaAction").getter(getter(ReceiptAction::lambdaAction)).setter(setter(Builder::lambdaAction))
            .constructor(LambdaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaAction").build()).build();

    private static final SdkField<StopAction> STOP_ACTION_FIELD = SdkField.<StopAction> builder(MarshallingType.SDK_POJO)
            .memberName("StopAction").getter(getter(ReceiptAction::stopAction)).setter(setter(Builder::stopAction))
            .constructor(StopAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopAction").build()).build();

    private static final SdkField<AddHeaderAction> ADD_HEADER_ACTION_FIELD = SdkField
            .<AddHeaderAction> builder(MarshallingType.SDK_POJO).memberName("AddHeaderAction")
            .getter(getter(ReceiptAction::addHeaderAction)).setter(setter(Builder::addHeaderAction))
            .constructor(AddHeaderAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddHeaderAction").build()).build();

    private static final SdkField<SNSAction> SNS_ACTION_FIELD = SdkField.<SNSAction> builder(MarshallingType.SDK_POJO)
            .memberName("SNSAction").getter(getter(ReceiptAction::snsAction)).setter(setter(Builder::snsAction))
            .constructor(SNSAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACTION_FIELD,
            BOUNCE_ACTION_FIELD, WORKMAIL_ACTION_FIELD, LAMBDA_ACTION_FIELD, STOP_ACTION_FIELD, ADD_HEADER_ACTION_FIELD,
            SNS_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Action s3Action;

    private final BounceAction bounceAction;

    private final WorkmailAction workmailAction;

    private final LambdaAction lambdaAction;

    private final StopAction stopAction;

    private final AddHeaderAction addHeaderAction;

    private final SNSAction snsAction;

    private ReceiptAction(BuilderImpl builder) {
        this.s3Action = builder.s3Action;
        this.bounceAction = builder.bounceAction;
        this.workmailAction = builder.workmailAction;
        this.lambdaAction = builder.lambdaAction;
        this.stopAction = builder.stopAction;
        this.addHeaderAction = builder.addHeaderAction;
        this.snsAction = builder.snsAction;
    }

    /**
     * <p>
     * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
     * notification to Amazon SNS.
     * </p>
     * 
     * @return Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally,
     *         publishes a notification to Amazon SNS.
     */
    public final S3Action s3Action() {
        return s3Action;
    }

    /**
     * <p>
     * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification
     * to Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * 
     * @return Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
     *         notification to Amazon Simple Notification Service (Amazon SNS).
     */
    public final BounceAction bounceAction() {
        return bounceAction;
    }

    /**
     * <p>
     * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
     * </p>
     * 
     * @return Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
     */
    public final WorkmailAction workmailAction() {
        return workmailAction;
    }

    /**
     * <p>
     * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     * </p>
     * 
     * @return Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     */
    public final LambdaAction lambdaAction() {
        return lambdaAction;
    }

    /**
     * <p>
     * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     * </p>
     * 
     * @return Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     */
    public final StopAction stopAction() {
        return stopAction;
    }

    /**
     * <p>
     * Adds a header to the received email.
     * </p>
     * 
     * @return Adds a header to the received email.
     */
    public final AddHeaderAction addHeaderAction() {
        return addHeaderAction;
    }

    /**
     * <p>
     * Publishes the email content within a notification to Amazon SNS.
     * </p>
     * 
     * @return Publishes the email content within a notification to Amazon SNS.
     */
    public final SNSAction snsAction() {
        return snsAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Action());
        hashCode = 31 * hashCode + Objects.hashCode(bounceAction());
        hashCode = 31 * hashCode + Objects.hashCode(workmailAction());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAction());
        hashCode = 31 * hashCode + Objects.hashCode(stopAction());
        hashCode = 31 * hashCode + Objects.hashCode(addHeaderAction());
        hashCode = 31 * hashCode + Objects.hashCode(snsAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptAction)) {
            return false;
        }
        ReceiptAction other = (ReceiptAction) obj;
        return Objects.equals(s3Action(), other.s3Action()) && Objects.equals(bounceAction(), other.bounceAction())
                && Objects.equals(workmailAction(), other.workmailAction())
                && Objects.equals(lambdaAction(), other.lambdaAction()) && Objects.equals(stopAction(), other.stopAction())
                && Objects.equals(addHeaderAction(), other.addHeaderAction()) && Objects.equals(snsAction(), other.snsAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReceiptAction").add("S3Action", s3Action()).add("BounceAction", bounceAction())
                .add("WorkmailAction", workmailAction()).add("LambdaAction", lambdaAction()).add("StopAction", stopAction())
                .add("AddHeaderAction", addHeaderAction()).add("SNSAction", snsAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Action":
            return Optional.ofNullable(clazz.cast(s3Action()));
        case "BounceAction":
            return Optional.ofNullable(clazz.cast(bounceAction()));
        case "WorkmailAction":
            return Optional.ofNullable(clazz.cast(workmailAction()));
        case "LambdaAction":
            return Optional.ofNullable(clazz.cast(lambdaAction()));
        case "StopAction":
            return Optional.ofNullable(clazz.cast(stopAction()));
        case "AddHeaderAction":
            return Optional.ofNullable(clazz.cast(addHeaderAction()));
        case "SNSAction":
            return Optional.ofNullable(clazz.cast(snsAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceiptAction, T> g) {
        return obj -> g.apply((ReceiptAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReceiptAction> {
        /**
         * <p>
         * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
         * a notification to Amazon SNS.
         * </p>
         * 
         * @param s3Action
         *        Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally,
         *        publishes a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Action(S3Action s3Action);

        /**
         * <p>
         * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
         * a notification to Amazon SNS.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Action.Builder} avoiding the need to create
         * one manually via {@link S3Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Action.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Action(S3Action)}.
         * 
         * @param s3Action
         *        a consumer that will call methods on {@link S3Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Action(S3Action)
         */
        default Builder s3Action(Consumer<S3Action.Builder> s3Action) {
            return s3Action(S3Action.builder().applyMutation(s3Action).build());
        }

        /**
         * <p>
         * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
         * notification to Amazon Simple Notification Service (Amazon SNS).
         * </p>
         * 
         * @param bounceAction
         *        Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
         *        notification to Amazon Simple Notification Service (Amazon SNS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounceAction(BounceAction bounceAction);

        /**
         * <p>
         * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
         * notification to Amazon Simple Notification Service (Amazon SNS).
         * </p>
         * This is a convenience that creates an instance of the {@link BounceAction.Builder} avoiding the need to
         * create one manually via {@link BounceAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link BounceAction.Builder#build()} is called immediately and its
         * result is passed to {@link #bounceAction(BounceAction)}.
         * 
         * @param bounceAction
         *        a consumer that will call methods on {@link BounceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bounceAction(BounceAction)
         */
        default Builder bounceAction(Consumer<BounceAction.Builder> bounceAction) {
            return bounceAction(BounceAction.builder().applyMutation(bounceAction).build());
        }

        /**
         * <p>
         * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
         * </p>
         * 
         * @param workmailAction
         *        Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workmailAction(WorkmailAction workmailAction);

        /**
         * <p>
         * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkmailAction.Builder} avoiding the need to
         * create one manually via {@link WorkmailAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkmailAction.Builder#build()} is called immediately and its
         * result is passed to {@link #workmailAction(WorkmailAction)}.
         * 
         * @param workmailAction
         *        a consumer that will call methods on {@link WorkmailAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workmailAction(WorkmailAction)
         */
        default Builder workmailAction(Consumer<WorkmailAction.Builder> workmailAction) {
            return workmailAction(WorkmailAction.builder().applyMutation(workmailAction).build());
        }

        /**
         * <p>
         * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
         * </p>
         * 
         * @param lambdaAction
         *        Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAction(LambdaAction lambdaAction);

        /**
         * <p>
         * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaAction.Builder} avoiding the need to
         * create one manually via {@link LambdaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaAction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaAction(LambdaAction)}.
         * 
         * @param lambdaAction
         *        a consumer that will call methods on {@link LambdaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAction(LambdaAction)
         */
        default Builder lambdaAction(Consumer<LambdaAction.Builder> lambdaAction) {
            return lambdaAction(LambdaAction.builder().applyMutation(lambdaAction).build());
        }

        /**
         * <p>
         * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
         * </p>
         * 
         * @param stopAction
         *        Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon
         *        SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopAction(StopAction stopAction);

        /**
         * <p>
         * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
         * </p>
         * This is a convenience that creates an instance of the {@link StopAction.Builder} avoiding the need to create
         * one manually via {@link StopAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link StopAction.Builder#build()} is called immediately and its result
         * is passed to {@link #stopAction(StopAction)}.
         * 
         * @param stopAction
         *        a consumer that will call methods on {@link StopAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopAction(StopAction)
         */
        default Builder stopAction(Consumer<StopAction.Builder> stopAction) {
            return stopAction(StopAction.builder().applyMutation(stopAction).build());
        }

        /**
         * <p>
         * Adds a header to the received email.
         * </p>
         * 
         * @param addHeaderAction
         *        Adds a header to the received email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addHeaderAction(AddHeaderAction addHeaderAction);

        /**
         * <p>
         * Adds a header to the received email.
         * </p>
         * This is a convenience that creates an instance of the {@link AddHeaderAction.Builder} avoiding the need to
         * create one manually via {@link AddHeaderAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link AddHeaderAction.Builder#build()} is called immediately and its
         * result is passed to {@link #addHeaderAction(AddHeaderAction)}.
         * 
         * @param addHeaderAction
         *        a consumer that will call methods on {@link AddHeaderAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addHeaderAction(AddHeaderAction)
         */
        default Builder addHeaderAction(Consumer<AddHeaderAction.Builder> addHeaderAction) {
            return addHeaderAction(AddHeaderAction.builder().applyMutation(addHeaderAction).build());
        }

        /**
         * <p>
         * Publishes the email content within a notification to Amazon SNS.
         * </p>
         * 
         * @param snsAction
         *        Publishes the email content within a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsAction(SNSAction snsAction);

        /**
         * <p>
         * Publishes the email content within a notification to Amazon SNS.
         * </p>
         * This is a convenience that creates an instance of the {@link SNSAction.Builder} avoiding the need to create
         * one manually via {@link SNSAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SNSAction.Builder#build()} is called immediately and its result
         * is passed to {@link #snsAction(SNSAction)}.
         * 
         * @param snsAction
         *        a consumer that will call methods on {@link SNSAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsAction(SNSAction)
         */
        default Builder snsAction(Consumer<SNSAction.Builder> snsAction) {
            return snsAction(SNSAction.builder().applyMutation(snsAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Action s3Action;

        private BounceAction bounceAction;

        private WorkmailAction workmailAction;

        private LambdaAction lambdaAction;

        private StopAction stopAction;

        private AddHeaderAction addHeaderAction;

        private SNSAction snsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptAction model) {
            s3Action(model.s3Action);
            bounceAction(model.bounceAction);
            workmailAction(model.workmailAction);
            lambdaAction(model.lambdaAction);
            stopAction(model.stopAction);
            addHeaderAction(model.addHeaderAction);
            snsAction(model.snsAction);
        }

        public final S3Action.Builder getS3Action() {
            return s3Action != null ? s3Action.toBuilder() : null;
        }

        @Override
        public final Builder s3Action(S3Action s3Action) {
            this.s3Action = s3Action;
            return this;
        }

        public final void setS3Action(S3Action.BuilderImpl s3Action) {
            this.s3Action = s3Action != null ? s3Action.build() : null;
        }

        public final BounceAction.Builder getBounceAction() {
            return bounceAction != null ? bounceAction.toBuilder() : null;
        }

        @Override
        public final Builder bounceAction(BounceAction bounceAction) {
            this.bounceAction = bounceAction;
            return this;
        }

        public final void setBounceAction(BounceAction.BuilderImpl bounceAction) {
            this.bounceAction = bounceAction != null ? bounceAction.build() : null;
        }

        public final WorkmailAction.Builder getWorkmailAction() {
            return workmailAction != null ? workmailAction.toBuilder() : null;
        }

        @Override
        public final Builder workmailAction(WorkmailAction workmailAction) {
            this.workmailAction = workmailAction;
            return this;
        }

        public final void setWorkmailAction(WorkmailAction.BuilderImpl workmailAction) {
            this.workmailAction = workmailAction != null ? workmailAction.build() : null;
        }

        public final LambdaAction.Builder getLambdaAction() {
            return lambdaAction != null ? lambdaAction.toBuilder() : null;
        }

        @Override
        public final Builder lambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
            return this;
        }

        public final void setLambdaAction(LambdaAction.BuilderImpl lambdaAction) {
            this.lambdaAction = lambdaAction != null ? lambdaAction.build() : null;
        }

        public final StopAction.Builder getStopAction() {
            return stopAction != null ? stopAction.toBuilder() : null;
        }

        @Override
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        public final void setStopAction(StopAction.BuilderImpl stopAction) {
            this.stopAction = stopAction != null ? stopAction.build() : null;
        }

        public final AddHeaderAction.Builder getAddHeaderAction() {
            return addHeaderAction != null ? addHeaderAction.toBuilder() : null;
        }

        @Override
        public final Builder addHeaderAction(AddHeaderAction addHeaderAction) {
            this.addHeaderAction = addHeaderAction;
            return this;
        }

        public final void setAddHeaderAction(AddHeaderAction.BuilderImpl addHeaderAction) {
            this.addHeaderAction = addHeaderAction != null ? addHeaderAction.build() : null;
        }

        public final SNSAction.Builder getSnsAction() {
            return snsAction != null ? snsAction.toBuilder() : null;
        }

        @Override
        public final Builder snsAction(SNSAction snsAction) {
            this.snsAction = snsAction;
            return this;
        }

        public final void setSnsAction(SNSAction.BuilderImpl snsAction) {
            this.snsAction = snsAction != null ? snsAction.build() : null;
        }

        @Override
        public ReceiptAction build() {
            return new ReceiptAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
